/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import io.quarkus.deployment.codegen.CodeGenData;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class CodeGenerator {
    public static void initAndRun(ClassLoader classLoader, PathsCollection sourceParentDirs, Path generatedSourcesDir, Path buildDir, Consumer<Path> sourceRegistrar, ApplicationModel appModel, Properties properties, String launchMode) throws CodeGenException {
        List<CodeGenData> generators = CodeGenerator.init(classLoader, sourceParentDirs, generatedSourcesDir, buildDir, sourceRegistrar);
        for (CodeGenData generator : generators) {
            generator.setRedirectIO(true);
            CodeGenerator.trigger(classLoader, generator, appModel, properties, LaunchMode.valueOf((String)launchMode));
        }
    }

    public static List<CodeGenData> init(ClassLoader deploymentClassLoader, PathsCollection sourceParentDirs, Path generatedSourcesDir, Path buildDir, Consumer<Path> sourceRegistrar) throws CodeGenException {
        return CodeGenerator.callWithClassloader(deploymentClassLoader, () -> {
            Class<?> codeGenProviderClass;
            ArrayList<CodeGenData> result = new ArrayList<CodeGenData>();
            try {
                codeGenProviderClass = deploymentClassLoader.loadClass(CodeGenProvider.class.getName());
            }
            catch (ClassNotFoundException e) {
                throw new CodeGenException("Failed to load CodeGenProvider class from deployment classloader", (Throwable)e);
            }
            for (CodeGenProvider provider : ServiceLoader.load(codeGenProviderClass, deploymentClassLoader)) {
                Path outputDir = CodeGenerator.codeGenOutDir(generatedSourcesDir, provider, sourceRegistrar);
                for (Path sourceParentDir : sourceParentDirs) {
                    result.add(new CodeGenData(provider, outputDir, sourceParentDir.resolve(provider.inputDirectory()), buildDir));
                }
            }
            return result;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T callWithClassloader(ClassLoader deploymentClassLoader, CodeGenAction<T> supplier) throws CodeGenException {
        ClassLoader originalClassloader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(deploymentClassLoader);
            T t = supplier.fire();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassloader);
        }
    }

    public static boolean trigger(ClassLoader deploymentClassLoader, CodeGenData data, ApplicationModel appModel, Properties properties, LaunchMode launchMode) throws CodeGenException {
        return CodeGenerator.callWithClassloader(deploymentClassLoader, () -> {
            PropertiesConfigSource pcs = new PropertiesConfigSource(properties, "Build system");
            SmallRyeConfig config = ConfigUtils.configBuilder((boolean)false, (LaunchMode)launchMode).withProfile(launchMode.getDefaultProfile()).withSources(new ConfigSource[]{pcs}).build();
            CodeGenProvider provider = data.provider;
            return Files.isDirectory(data.sourceDir, new LinkOption[0]) && provider.trigger(new CodeGenContext(appModel, data.outPath, data.buildDir, data.sourceDir, data.redirectIO, (Config)config));
        });
    }

    private static Path codeGenOutDir(Path generatedSourcesDir, CodeGenProvider provider, Consumer<Path> sourceRegistrar) throws CodeGenException {
        Path outputDir = generatedSourcesDir.resolve(provider.providerId());
        try {
            Files.createDirectories(outputDir, new FileAttribute[0]);
            sourceRegistrar.accept(outputDir);
            return outputDir;
        }
        catch (IOException e) {
            throw new CodeGenException("Failed to create output directory for generated sources: " + outputDir.toAbsolutePath(), (Throwable)e);
        }
    }

    @FunctionalInterface
    private static interface CodeGenAction<T> {
        public T fire() throws CodeGenException;
    }
}

