/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.model.ArtifactCoords;
import io.quarkus.registry.model.ArtifactKey;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableArtifactCoords
implements ArtifactCoords {
    private final ArtifactKey id;
    private final String version;

    private ImmutableArtifactCoords(ArtifactKey id, String version) {
        this.id = Objects.requireNonNull(id, "id");
        this.version = Objects.requireNonNull(version, "version");
    }

    private ImmutableArtifactCoords(ImmutableArtifactCoords original, ArtifactKey id, String version) {
        this.id = id;
        this.version = version;
    }

    @Override
    @JsonProperty(value="id")
    @JsonUnwrapped
    public ArtifactKey getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    public final ImmutableArtifactCoords withId(ArtifactKey value) {
        if (this.id == value) {
            return this;
        }
        ArtifactKey newValue = Objects.requireNonNull(value, "id");
        return new ImmutableArtifactCoords(this, newValue, this.version);
    }

    public final ImmutableArtifactCoords withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableArtifactCoords(this, this.id, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableArtifactCoords && this.equalTo((ImmutableArtifactCoords)another);
    }

    private boolean equalTo(ImmutableArtifactCoords another) {
        return this.id.equals(another.id) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return "ArtifactCoords{id=" + this.id + ", version=" + this.version + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableArtifactCoords fromJson(Json json) {
        Builder builder = ImmutableArtifactCoords.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static ImmutableArtifactCoords of(ArtifactKey id, String version) {
        return new ImmutableArtifactCoords(id, version);
    }

    public static ImmutableArtifactCoords copyOf(ArtifactCoords instance) {
        if (instance instanceof ImmutableArtifactCoords) {
            return (ImmutableArtifactCoords)instance;
        }
        return ImmutableArtifactCoords.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private long initBits = 3L;
        private ArtifactKey id;
        private String version;

        private Builder() {
        }

        public final Builder from(ArtifactCoords instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.version(instance.getVersion());
            return this;
        }

        @JsonProperty(value="id")
        @JsonUnwrapped
        public final Builder id(ArtifactKey id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="version")
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableArtifactCoords build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableArtifactCoords(null, this.id, this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build ArtifactCoords, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ArtifactCoords {
        ArtifactKey id;
        String version;

        Json() {
        }

        @JsonProperty(value="id")
        @JsonUnwrapped
        public void setId(ArtifactKey id) {
            this.id = id;
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }

        @Override
        public ArtifactKey getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }
    }
}

