/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands;

import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.CreateJBangProjectCommandHandler;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CreateJBangProject {
    public static final String NAME = "create-jbang";
    private final Path projectDirPath;
    private final QuarkusPlatformDescriptor platformDescr;
    private BuildTool buildTool = BuildTool.MAVEN;
    private Set<String> extensions = new HashSet<String>();
    private Map<String, Object> values = new HashMap<String, Object>();

    public CreateJBangProject(Path projectDirPath, QuarkusPlatformDescriptor platformDescr) {
        this.projectDirPath = Objects.requireNonNull(projectDirPath, "projectDirPath is required");
        this.platformDescr = Objects.requireNonNull(platformDescr, "platformDescr is required");
    }

    public CreateJBangProject extensions(Set<String> extensions) {
        if (extensions == null) {
            return this;
        }
        this.extensions.addAll(extensions);
        return this;
    }

    public CreateJBangProject setValue(String name, Object value) {
        if (value != null) {
            this.values.put(name, value);
        }
        return this;
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        this.setValue("extensions", this.extensions);
        QuarkusProject quarkusProject = QuarkusProject.of(this.projectDirPath, this.platformDescr, this.buildTool);
        QuarkusCommandInvocation invocation = new QuarkusCommandInvocation(quarkusProject, this.values);
        return new CreateJBangProjectCommandHandler().execute(invocation);
    }
}

