/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.extensions;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.extensions.ExtensionInstallPlan;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;

public interface ExtensionManager {
    public BuildTool getBuildTool();

    public Collection<AppArtifactCoords> getInstalled() throws IOException;

    default public boolean isInstalled(AppArtifactKey key) throws IOException {
        return this.getInstalled().stream().anyMatch(i -> Objects.equals(i.getKey(), key));
    }

    public InstallResult install(Collection<AppArtifactCoords> var1) throws IOException;

    public InstallResult install(ExtensionInstallPlan var1) throws IOException;

    public UninstallResult uninstall(Collection<AppArtifactKey> var1) throws IOException;

    public static class UninstallResult {
        private final Collection<AppArtifactKey> uninstalled;

        public UninstallResult(Collection<AppArtifactKey> uninstalled) {
            this.uninstalled = uninstalled;
        }

        public Collection<AppArtifactKey> getUninstalled() {
            return this.uninstalled;
        }

        public boolean isSourceUpdated() {
            return this.uninstalled.size() > 0;
        }
    }

    public static class InstallResult {
        private final Collection<AppArtifactCoords> installed;

        public InstallResult(Collection<AppArtifactCoords> installed) {
            this.installed = installed;
        }

        public Collection<AppArtifactCoords> getInstalled() {
            return this.installed;
        }

        public boolean isSourceUpdated() {
            return this.installed.size() > 0;
        }
    }
}

