/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.runtime.query;

import io.quarkus.arc.impl.Reflections;
import io.quarkus.funqy.runtime.query.BaseObjectReader;
import io.quarkus.funqy.runtime.query.QueryObjectMapper;
import io.quarkus.funqy.runtime.query.QueryPropertySetter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

class QueryMapReader
extends BaseObjectReader
implements BaseObjectReader.ValueSetter {
    private Function<String, Object> keyExtractor;
    private Function<String, Object> valueExtractor;
    private QueryPropertySetter setter;

    public QueryMapReader(Type genericType, QueryObjectMapper mapper) {
        if (genericType == null) {
            this.keyExtractor = mapper.extractor(String.class);
            this.valueExtractor = mapper.extractor(String.class);
            return;
        }
        if (genericType instanceof ParameterizedType) {
            Type keyType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            this.keyExtractor = mapper.extractor(keyType);
            if (keyType == null) {
                throw new RuntimeException("Illegal key type for map");
            }
            Type valueType = ((ParameterizedType)genericType).getActualTypeArguments()[1];
            if (valueType != null) {
                Class rawType = Reflections.getRawType((Type)valueType);
                this.valueExtractor = mapper.extractor(valueType);
                if (this.valueExtractor == null) {
                    this.setter = mapper.setterFor(rawType, valueType);
                }
            } else {
                this.valueExtractor = mapper.extractor(String.class);
            }
        } else {
            this.keyExtractor = mapper.extractor(String.class);
            Class rawType = Reflections.getRawType((Type)genericType);
            this.valueExtractor = mapper.extractor(rawType);
            if (this.valueExtractor == null) {
                this.setter = mapper.setterFor(rawType, genericType);
            }
        }
    }

    @Override
    public void setValue(Object target, String propName, Object value) {
        ((Map)target).put(this.keyExtractor.apply(propName), value);
    }

    @Override
    public Function<String, Object> getExtractor() {
        return this.valueExtractor;
    }

    @Override
    public QueryPropertySetter getSetter() {
        return this.setter;
    }

    @Override
    BaseObjectReader.ValueSetter getValueSetter(String propName) {
        return this;
    }

    @Override
    public Object create() {
        return new HashMap();
    }
}

