/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.mockito.internal;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.impl.Mockable;
import io.quarkus.test.junit.callback.QuarkusTestAfterConstructCallback;
import io.quarkus.test.junit.mockito.InjectMock;
import io.quarkus.test.junit.mockito.internal.MockitoMocksTracker;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Qualifier;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class CreateMockitoMocksCallback
implements QuarkusTestAfterConstructCallback {
    public void afterConstruct(Object testInstance) {
        Class<?> current = testInstance.getClass();
        while (current.getSuperclass() != null) {
            for (Field field : current.getDeclaredFields()) {
                InjectMock injectMockAnnotation = field.getAnnotation(InjectMock.class);
                if (injectMockAnnotation == null) continue;
                boolean returnsDeepMocks = injectMockAnnotation.returnsDeepMocks();
                Object beanInstance = CreateMockitoMocksCallback.getBeanInstance(testInstance, field, InjectMock.class);
                Optional<Object> result = this.createMockAndSetTestField(testInstance, field, beanInstance, new MockConfiguration(returnsDeepMocks));
                if (!result.isPresent()) continue;
                MockitoMocksTracker.track(testInstance, result.get(), beanInstance);
            }
            current = current.getSuperclass();
        }
    }

    private Optional<Object> createMockAndSetTestField(Object testInstance, Field field, Object beanInstance, MockConfiguration mockConfiguration) {
        boolean isNew;
        Object mock;
        Optional<Object> currentMock;
        Class beanClass = beanInstance.getClass();
        if (ClientProxy.class.isAssignableFrom(beanClass)) {
            if (beanClass.getSuperclass() != Object.class) {
                beanClass = beanClass.getSuperclass();
            } else {
                HashSet foundInterf = new HashSet();
                for (Class<?> interf : beanClass.getInterfaces()) {
                    if (interf == Mockable.class || interf == ClientProxy.class) continue;
                    foundInterf.add(interf);
                }
                if (foundInterf.size() == 1) {
                    beanClass = (Class)foundInterf.iterator().next();
                }
            }
        }
        if ((currentMock = MockitoMocksTracker.currentMock(testInstance, beanInstance)).isPresent()) {
            mock = currentMock.get();
            isNew = false;
        } else {
            mock = mockConfiguration.useDeepMocks ? Mockito.mock(beanClass, (Answer)Mockito.RETURNS_DEEP_STUBS) : Mockito.mock(beanClass);
            isNew = true;
        }
        field.setAccessible(true);
        try {
            field.set(testInstance, mock);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (isNew) {
            return Optional.of(mock);
        }
        return Optional.empty();
    }

    static Object getBeanInstance(Object testInstance, Field field, Class<? extends Annotation> annotationType) {
        Type fieldType = field.getGenericType();
        Annotation[] qualifiers = CreateMockitoMocksCallback.getQualifiers(field);
        ArcContainer container = Arc.container();
        BeanManager beanManager = container.beanManager();
        Set beans = beanManager.getBeans(fieldType, qualifiers);
        if (beans.isEmpty()) {
            throw new IllegalStateException("Invalid use of " + annotationType.getTypeName() + " - could not resolve the bean of type: " + fieldType.getTypeName() + ". Offending field is " + field.getName() + " of test class " + testInstance.getClass());
        }
        Bean bean = beanManager.resolve(beans);
        if (!beanManager.isNormalScope(bean.getScope())) {
            throw new IllegalStateException("Invalid use of " + annotationType.getTypeName() + " - the injected bean does not declare a CDI normal scope but: " + bean.getScope().getName() + ". Offending field is " + field.getName() + " of test class " + testInstance.getClass());
        }
        return container.instance((InjectableBean)bean).get();
    }

    static Annotation[] getQualifiers(Field fieldToMock) {
        Annotation[] fieldAnnotations;
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
        block0: for (Annotation fieldAnnotation : fieldAnnotations = fieldToMock.getDeclaredAnnotations()) {
            for (Annotation annotationOfFieldAnnotation : fieldAnnotation.annotationType().getAnnotations()) {
                if (!annotationOfFieldAnnotation.annotationType().equals(Qualifier.class)) continue;
                qualifiers.add(fieldAnnotation);
                continue block0;
            }
        }
        return qualifiers.toArray(new Annotation[0]);
    }

    private static class MockConfiguration {
        final boolean useDeepMocks;

        private MockConfiguration(boolean useDeepMocks) {
            this.useDeepMocks = useDeepMocks;
        }
    }
}

