/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime.interceptor;

import com.arjuna.ats.jta.logging.jtaLogger;
import io.quarkus.arc.runtime.InterceptorBindings;
import io.quarkus.narayana.jta.runtime.CDIDelegatingTransactionManager;
import io.quarkus.narayana.jta.runtime.TransactionConfiguration;
import io.quarkus.narayana.jta.runtime.interceptor.RunnableWithException;
import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.converters.ReactiveTypeConverter;
import io.smallrye.reactive.converters.Registry;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.Transactional;
import org.jboss.tm.usertx.client.ServerVMClientUserTransaction;
import org.reactivestreams.Publisher;

public abstract class TransactionalInterceptorBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    TransactionManager transactionManager;
    private final boolean userTransactionAvailable;

    protected TransactionalInterceptorBase(boolean userTransactionAvailable) {
        this.userTransactionAvailable = userTransactionAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(InvocationContext ic) throws Exception {
        TransactionManager tm = this.transactionManager;
        Transaction tx = tm.getTransaction();
        boolean previousUserTransactionAvailability = this.setUserTransactionAvailable(this.userTransactionAvailable);
        try {
            Object object = this.doIntercept(tm, tx, ic);
            return object;
        }
        finally {
            this.resetUserTransactionAvailability(previousUserTransactionAvailability);
        }
    }

    protected abstract Object doIntercept(TransactionManager var1, Transaction var2, InvocationContext var3) throws Exception;

    private Transactional getTransactional(InvocationContext ic) {
        Set bindings = InterceptorBindings.getInterceptorBindings((InvocationContext)ic);
        for (Annotation i : bindings) {
            if (i.annotationType() != Transactional.class) continue;
            return (Transactional)i;
        }
        throw new RuntimeException(jtaLogger.i18NLogger.get_expected_transactional_annotation());
    }

    private TransactionConfiguration getTransactionConfiguration(InvocationContext ic) {
        TransactionConfiguration configuration = ic.getMethod().getAnnotation(TransactionConfiguration.class);
        if (configuration == null) {
            Object target = ic.getTarget();
            Class<?> clazz = target != null ? target.getClass() : ic.getMethod().getDeclaringClass();
            return clazz.getAnnotation(TransactionConfiguration.class);
        }
        return configuration;
    }

    protected Object invokeInOurTx(InvocationContext ic, TransactionManager tm) throws Exception {
        return this.invokeInOurTx(ic, tm, () -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInOurTx(InvocationContext ic, TransactionManager tm, RunnableWithException afterEndTransaction) throws Exception {
        Transaction tx;
        TransactionConfiguration configAnnotation = this.getTransactionConfiguration(ic);
        int currentTmTimeout = ((CDIDelegatingTransactionManager)this.transactionManager).getTransactionTimeout();
        if (configAnnotation != null && configAnnotation.timeout() != -1) {
            tm.setTransactionTimeout(configAnnotation.timeout());
        }
        try {
            tm.begin();
            tx = tm.getTransaction();
        }
        finally {
            if (configAnnotation != null && configAnnotation.timeout() != -1) {
                tm.setTransactionTimeout(currentTmTimeout);
            }
        }
        boolean throwing = false;
        CompletionStage ret = null;
        try {
            ret = ic.proceed();
        }
        catch (Exception e) {
            throwing = true;
            this.handleException(ic, e, tx);
        }
        finally {
            if (!throwing && ret != null) {
                Optional lookup;
                ReactiveTypeConverter converter = null;
                if (!(ret instanceof CompletionStage || ret instanceof Publisher && ic.getMethod().getReturnType() == Publisher.class || !(lookup = Registry.lookup(ret.getClass())).isPresent())) {
                    converter = (ReactiveTypeConverter)lookup.get();
                    ret = converter.emitAtMostOneItem() ? converter.toCompletionStage((Object)ret) : converter.toRSPublisher((Object)ret);
                }
                if (ret instanceof CompletionStage) {
                    ret = this.handleAsync(tm, tx, ic, ret, afterEndTransaction);
                    if (converter != null) {
                        ret = converter.fromCompletionStage(ret);
                    }
                } else if (ret instanceof Publisher) {
                    ret = this.handleAsync(tm, tx, ic, ret, afterEndTransaction);
                    if (converter != null) {
                        ret = converter.fromPublisher((Publisher)ret);
                    }
                } else {
                    this.endTransaction(tm, tx, afterEndTransaction);
                }
            } else {
                this.endTransaction(tm, tx, afterEndTransaction);
            }
        }
        return ret;
    }

    protected Object handleAsync(TransactionManager tm, Transaction tx, InvocationContext ic, Object ret, RunnableWithException afterEndTransaction) throws Exception {
        tm.suspend();
        afterEndTransaction.run();
        if (ret instanceof CompletionStage) {
            return ((CompletionStage)ret).handle((v, t) -> {
                try {
                    this.doInTransaction(tm, tx, () -> {
                        if (t != null) {
                            this.handleExceptionNoThrow(ic, (Throwable)t, tx);
                        }
                        this.endTransaction(tm, tx, () -> {});
                    });
                }
                catch (RuntimeException e) {
                    if (t != null) {
                        e.addSuppressed((Throwable)t);
                    }
                    throw e;
                }
                catch (Exception e) {
                    CompletionException x = new CompletionException(e);
                    if (t != null) {
                        x.addSuppressed((Throwable)t);
                    }
                    throw x;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t != null) {
                    throw new CompletionException((Throwable)t);
                }
                return v;
            });
        }
        if (ret instanceof Publisher) {
            ret = Multi.createFrom().publisher((Publisher)ret).onFailure().invoke(t -> {
                try {
                    this.doInTransaction(tm, tx, () -> this.handleExceptionNoThrow(ic, (Throwable)t, tx));
                }
                catch (RuntimeException e) {
                    e.addSuppressed((Throwable)t);
                    throw e;
                }
                catch (Exception e) {
                    RuntimeException x = new RuntimeException(e);
                    x.addSuppressed((Throwable)t);
                    throw x;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException((Throwable)t);
            }).on().termination(() -> {
                try {
                    this.doInTransaction(tm, tx, () -> this.endTransaction(tm, tx, () -> {}));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return ret;
    }

    private void doInTransaction(TransactionManager tm, Transaction tx, RunnableWithException f) throws Exception {
        Transaction currentTransaction = tm.getTransaction();
        if (currentTransaction != tx) {
            if (currentTransaction != null) {
                tm.suspend();
            }
            tm.resume(tx);
        }
        f.run();
        if (currentTransaction != tx) {
            tm.suspend();
            if (currentTransaction != null) {
                tm.resume(currentTransaction);
            }
        }
    }

    protected Object invokeInCallerTx(InvocationContext ic, Transaction tx) throws Exception {
        try {
            this.checkConfiguration(ic);
            return ic.proceed();
        }
        catch (Exception e) {
            this.handleException(ic, e, tx);
            throw new RuntimeException("UNREACHABLE");
        }
    }

    protected Object invokeInNoTx(InvocationContext ic) throws Exception {
        this.checkConfiguration(ic);
        return ic.proceed();
    }

    private void checkConfiguration(InvocationContext ic) {
        TransactionConfiguration configAnnotation = this.getTransactionConfiguration(ic);
        if (configAnnotation != null && configAnnotation.timeout() != -1) {
            throw new RuntimeException("Changing timeout via @TransactionConfiguration can only be done at the entry level of a transaction");
        }
    }

    protected void handleExceptionNoThrow(InvocationContext ic, Throwable e, Transaction tx) throws IllegalStateException, SystemException {
        Transactional transactional = this.getTransactional(ic);
        for (Class dontRollbackOnClass : transactional.dontRollbackOn()) {
            if (!dontRollbackOnClass.isAssignableFrom(e.getClass())) continue;
            return;
        }
        for (Class rollbackOnClass : transactional.rollbackOn()) {
            if (!rollbackOnClass.isAssignableFrom(e.getClass())) continue;
            tx.setRollbackOnly();
            return;
        }
        if (e instanceof RuntimeException) {
            tx.setRollbackOnly();
            return;
        }
    }

    protected void handleException(InvocationContext ic, Exception e, Transaction tx) throws Exception {
        this.handleExceptionNoThrow(ic, e, tx);
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endTransaction(TransactionManager tm, Transaction tx, RunnableWithException afterEndTransaction) throws Exception {
        try {
            if (tx != tm.getTransaction()) {
                throw new RuntimeException(jtaLogger.i18NLogger.get_wrong_tx_on_thread());
            }
            if (tx.getStatus() == 1) {
                tm.rollback();
            } else {
                tm.commit();
            }
        }
        finally {
            afterEndTransaction.run();
        }
    }

    protected boolean setUserTransactionAvailable(boolean available) {
        boolean previousUserTransactionAvailability = ServerVMClientUserTransaction.isAvailable();
        ServerVMClientUserTransaction.setAvailability((boolean)available);
        return previousUserTransactionAvailability;
    }

    protected void resetUserTransactionAvailability(boolean previousUserTransactionAvailability) {
        ServerVMClientUserTransaction.setAvailability((boolean)previousUserTransactionAvailability);
    }
}

