/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.Tokens;
import io.smallrye.mutiny.Uni;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;

public class TokensHelper {
    private volatile TokenRequestState tokenRequestState;
    private static final AtomicReferenceFieldUpdater<TokensHelper, TokenRequestState> tokenRequestStateUpdater = AtomicReferenceFieldUpdater.newUpdater(TokensHelper.class, TokenRequestState.class, "tokenRequestState");

    public void initTokens(OidcClient oidcClient) {
        tokenRequestStateUpdater.set(this, new TokenRequestState((Tokens)oidcClient.getTokens().await().indefinitely()));
    }

    public Uni<Tokens> getTokens(OidcClient oidcClient) {
        Tokens tokens;
        block3: {
            TokenRequestState currentState = null;
            TokenRequestState newState = null;
            while (true) {
                if ((currentState = tokenRequestStateUpdater.get(this)) == null) {
                    newState = new TokenRequestState(this.prepareUni(oidcClient.getTokens()));
                    if (!tokenRequestStateUpdater.compareAndSet(this, currentState, newState)) continue;
                    return newState.tokenUni;
                }
                if (currentState.tokenUni != null) {
                    return currentState.tokenUni;
                }
                tokens = currentState.tokens;
                if (!tokens.isAccessTokenExpired() && !tokens.isAccessTokenWithinRefreshInterval()) break block3;
                newState = new TokenRequestState(this.prepareUni(tokens.getRefreshToken() != null && !tokens.isRefreshTokenExpired() ? oidcClient.refreshTokens(tokens.getRefreshToken()) : oidcClient.getTokens()));
                if (tokenRequestStateUpdater.compareAndSet(this, currentState, newState)) break;
            }
            return newState.tokenUni;
        }
        return Uni.createFrom().item((Object)tokens);
    }

    private Uni<Tokens> prepareUni(Uni<Tokens> tokens) {
        return tokens.onItemOrFailure().invoke((BiConsumer)new BiConsumer<Tokens, Throwable>(){

            @Override
            public void accept(Tokens tokens, Throwable throwable) {
                if (tokens != null) {
                    tokenRequestStateUpdater.set(TokensHelper.this, new TokenRequestState(tokens));
                } else {
                    tokenRequestStateUpdater.set(TokensHelper.this, null);
                }
            }
        });
    }

    static class TokenRequestState {
        final Tokens tokens;
        final Uni<Tokens> tokenUni;

        TokenRequestState(Tokens tokens) {
            this.tokens = tokens;
            this.tokenUni = null;
        }

        TokenRequestState(Uni<Tokens> tokensUni) {
            this.tokens = null;
            this.tokenUni = tokensUni;
        }
    }
}

