/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.resteasy.runtime.EagerSecurityFilter;
import io.quarkus.security.Authenticated;
import io.quarkus.security.PermissionsAllowed;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.Priority;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;

@Interceptor
@RolesAllowed(value={""})
@PermissionsAllowed(value={""})
@PermitAll
@Authenticated
@Priority(value=0)
public class PreventRepeatedSecurityChecksInterceptor {
    @Inject
    AuthorizationController controller;
    @Inject
    RoutingContext routingContext;

    @AroundInvoke
    public Object intercept(InvocationContext ic) throws Exception {
        Method method;
        if (this.controller.isAuthorizationEnabled() && (method = (Method)this.routingContext.get(EagerSecurityFilter.class.getName())) != null && method.equals(ic.getMethod())) {
            ic.getContextData().put("io.quarkus.security.securityHandler", "executed");
        }
        return ic.proceed();
    }
}

