/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyInjectionReadyBuildItem;
import io.quarkus.resteasy.runtime.ResteasyVertxConfig;
import io.quarkus.resteasy.runtime.standalone.ResteasyStandaloneRecorder;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.DefaultRouteBuildItem;
import io.quarkus.vertx.http.deployment.RequireVirtualHttpBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.vertx.core.Handler;
import java.util.Optional;
import java.util.concurrent.Executor;

public class ResteasyStandaloneBuildStep {
    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void staticInit(ResteasyStandaloneRecorder recorder, Capabilities capabilities, ResteasyDeploymentBuildItem deployment, ApplicationArchivesBuildItem applicationArchivesBuildItem, ResteasyInjectionReadyBuildItem resteasyInjectionReady, HttpBuildTimeConfig httpConfig, BuildProducer<ResteasyStandaloneBuildItem> standalone) throws Exception {
        if (capabilities.isPresent("io.quarkus.servlet")) {
            return;
        }
        String deploymentRootPath = null;
        Object rootPath = httpConfig.rootPath;
        if (deployment != null) {
            deploymentRootPath = deployment.getRootPath();
            if (((String)rootPath).endsWith("/")) {
                rootPath = deploymentRootPath.startsWith("/") ? (String)rootPath + deploymentRootPath.substring(1) : (String)rootPath + deploymentRootPath;
            } else if (!deploymentRootPath.equals("/")) {
                if (!deploymentRootPath.startsWith("/")) {
                    rootPath = (String)rootPath + "/";
                }
                rootPath = (String)rootPath + deploymentRootPath;
            }
            recorder.staticInit(deployment.getDeployment(), (String)rootPath);
            standalone.produce((BuildItem)new ResteasyStandaloneBuildItem(deploymentRootPath));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void boot(ShutdownContextBuildItem shutdown, ResteasyStandaloneRecorder recorder, BuildProducer<FeatureBuildItem> feature, BuildProducer<DefaultRouteBuildItem> defaultRoutes, BuildProducer<RouteBuildItem> routes, CoreVertxBuildItem vertx, BeanContainerBuildItem beanContainer, ResteasyStandaloneBuildItem standalone, Optional<RequireVirtualHttpBuildItem> requireVirtual, ExecutorBuildItem executorBuildItem, ResteasyVertxConfig resteasyVertxConfig, HttpConfiguration httpConfiguration) throws Exception {
        if (standalone == null) {
            return;
        }
        feature.produce((BuildItem)new FeatureBuildItem(Feature.RESTEASY));
        Handler handler = recorder.vertxRequestHandler(vertx.getVertx(), beanContainer.getValue(), (Executor)executorBuildItem.getExecutorProxy(), httpConfiguration, resteasyVertxConfig);
        routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute(standalone.deploymentRootPath, Integer.valueOf(10001)).handler(handler).build());
        Object matchPath = standalone.deploymentRootPath;
        matchPath = ((String)matchPath).endsWith("/") ? (String)matchPath + "*" : (String)matchPath + "/*";
        routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute((String)matchPath, Integer.valueOf(10001)).handler(handler).build());
        recorder.start((ShutdownContext)shutdown, requireVirtual.isPresent());
    }

    public static final class ResteasyStandaloneBuildItem
    extends SimpleBuildItem {
        final String deploymentRootPath;

        public ResteasyStandaloneBuildItem(String deploymentRootPath) {
            this.deploymentRootPath = deploymentRootPath.startsWith("/") ? deploymentRootPath : "/" + deploymentRootPath;
        }
    }
}

