/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime;

import io.quarkus.scheduler.FailedExecution;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.SuccessfulExecution;
import io.quarkus.scheduler.common.runtime.DelegateInvoker;
import io.quarkus.scheduler.common.runtime.Events;
import io.quarkus.scheduler.common.runtime.ScheduledInvoker;
import jakarta.enterprise.event.Event;
import java.util.concurrent.CompletionStage;
import org.jboss.logging.Logger;

public final class StatusEmitterInvoker
extends DelegateInvoker {
    private static final Logger LOG = Logger.getLogger(StatusEmitterInvoker.class);
    private final Event<SuccessfulExecution> successfulEvent;
    private final Event<FailedExecution> failedEvent;

    public StatusEmitterInvoker(ScheduledInvoker delegate, Event<SuccessfulExecution> successfulEvent, Event<FailedExecution> failedEvent) {
        super(delegate);
        this.successfulEvent = successfulEvent;
        this.failedEvent = failedEvent;
    }

    @Override
    public CompletionStage<Void> invoke(ScheduledExecution execution) throws Exception {
        return this.delegate.invoke(execution).whenComplete((v, t) -> {
            if (t != null) {
                LOG.errorf(t, "Error occurred while executing task for trigger %s", (Object)execution.getTrigger());
                Events.fire(this.failedEvent, new FailedExecution(execution, t));
            } else {
                Events.fire(this.successfulEvent, new SuccessfulExecution(execution));
            }
        });
    }
}

