/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.smallrye.openapi.runtime.OpenApiDocumentService;
import io.smallrye.openapi.runtime.io.Format;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpenApiHandler
implements Handler<RoutingContext> {
    private volatile OpenApiDocumentService openApiDocumentService;
    private static final String ALLOWED_METHODS = "GET, HEAD, OPTIONS";
    private static final String QUERY_PARAM_FORMAT = "format";
    private static final Map<String, String> RESPONSE_HEADERS = new HashMap<String, String>();

    public void handle(RoutingContext event) {
        HttpServerRequest req = event.request();
        HttpServerResponse resp = event.response();
        if (req.method().equals((Object)HttpMethod.OPTIONS)) {
            resp.headers().setAll(RESPONSE_HEADERS);
            resp.headers().set("Allow", ALLOWED_METHODS);
            event.next();
        } else {
            String accept = req.headers().get("Accept");
            List formatParams = event.queryParam(QUERY_PARAM_FORMAT);
            String formatParam = formatParams.isEmpty() ? null : (String)formatParams.get(0);
            Format format = Format.YAML;
            if (accept != null && accept.contains(Format.JSON.getMimeType()) || "JSON".equalsIgnoreCase(formatParam)) {
                format = Format.JSON;
            }
            resp.headers().setAll(RESPONSE_HEADERS);
            resp.headers().set("Content-Type", format.getMimeType() + ";charset=UTF-8");
            byte[] schemaDocument = this.getOpenApiDocumentService().getDocument(format);
            resp.end(Buffer.buffer((byte[])schemaDocument));
        }
    }

    private OpenApiDocumentService getOpenApiDocumentService() {
        if (this.openApiDocumentService == null) {
            this.openApiDocumentService = (OpenApiDocumentService)Arc.container().instance(OpenApiDocumentService.class, new Annotation[0]).get();
        }
        return this.openApiDocumentService;
    }

    static {
        RESPONSE_HEADERS.put("Access-Control-Allow-Origin", "*");
        RESPONSE_HEADERS.put("Access-Control-Allow-Credentials", "true");
        RESPONSE_HEADERS.put("Access-Control-Allow-Methods", ALLOWED_METHODS);
        RESPONSE_HEADERS.put("Access-Control-Allow-Headers", "Content-Type, Authorization");
        RESPONSE_HEADERS.put("Access-Control-Max-Age", "86400");
    }
}

