/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common.http;

import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.runtime.test.TestHttpEndpointProvider;
import io.quarkus.test.common.http.TestHTTPEndpoint;
import io.quarkus.test.common.http.TestHTTPResource;
import io.quarkus.test.common.http.TestHTTPResourceProvider;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.eclipse.microprofile.config.ConfigProvider;

public class TestHTTPResourceManager {
    public static String getUri() {
        try {
            return TestHTTPResourceManager.sanitizeUri((String)ConfigProvider.getConfig().getValue("test.url", String.class));
        }
        catch (IllegalStateException e) {
            return "http://localhost:8080";
        }
    }

    public static String getSslUri() {
        return TestHTTPResourceManager.sanitizeUri((String)ConfigProvider.getConfig().getValue("test.url.ssl", String.class));
    }

    private static String sanitizeUri(String result) {
        if (result != null && result.endsWith("/")) {
            return result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String getUri(RunningQuarkusApplication application) {
        return TestHTTPResourceManager.sanitizeUri((String)application.getConfigValue("test.url", String.class).get());
    }

    public static String getSslUri(RunningQuarkusApplication application) {
        return TestHTTPResourceManager.sanitizeUri((String)application.getConfigValue("test.url.ssl", String.class).get());
    }

    public static void inject(Object testCase) {
        TestHTTPResourceManager.inject(testCase, TestHttpEndpointProvider.load());
    }

    public static void inject(Object testCase, List<Function<Class<?>, String>> endpointProviders) {
        Map<Class<?>, TestHTTPResourceProvider<?>> providers = TestHTTPResourceManager.getProviders();
        for (Class<?> c = testCase.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                TestHTTPResource resource = f.getAnnotation(TestHTTPResource.class);
                if (resource == null) continue;
                TestHTTPResourceProvider<?> provider = providers.get(f.getType());
                if (provider == null) {
                    throw new RuntimeException("Unable to inject TestHTTPResource field " + f + " as no provider exists for the type");
                }
                Object path = resource.value();
                String endpointPath = null;
                TestHTTPEndpoint endpointAnnotation = f.getAnnotation(TestHTTPEndpoint.class);
                if (endpointAnnotation != null) {
                    Function<Class<?>, String> func;
                    Iterator<Function<Class<?>, String>> iterator = endpointProviders.iterator();
                    while (iterator.hasNext() && (endpointPath = (func = iterator.next()).apply(endpointAnnotation.value())) == null) {
                    }
                    if (endpointPath == null) {
                        throw new RuntimeException("Could not determine the endpoint path for " + endpointAnnotation.value() + " to inject " + f);
                    }
                }
                if (!((String)path).isEmpty() && endpointPath != null) {
                    path = !endpointPath.endsWith("/") ? endpointPath + "/" + (String)path : endpointPath + (String)path;
                } else if (endpointPath != null) {
                    path = endpointPath;
                }
                String val = resource.ssl() ? (((String)path).startsWith("/") ? TestHTTPResourceManager.getSslUri() + (String)path : TestHTTPResourceManager.getSslUri() + "/" + (String)path) : (((String)path).startsWith("/") ? TestHTTPResourceManager.getUri() + (String)path : TestHTTPResourceManager.getUri() + "/" + (String)path);
                f.setAccessible(true);
                try {
                    f.set(testCase, provider.provide(new URI(val), f));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static Map<Class<?>, TestHTTPResourceProvider<?>> getProviders() {
        HashMap map = new HashMap();
        for (TestHTTPResourceProvider i : ServiceLoader.load(TestHTTPResourceProvider.class, TestHTTPResourceProvider.class.getClassLoader())) {
            map.put(i.getProvidedType(), i);
        }
        return Collections.unmodifiableMap(map);
    }
}

