/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.menu;

import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.deployment.InternalPageBuildItem;
import io.quarkus.devui.runtime.config.ConfigJsonRPCService;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.vertx.http.deployment.devmode.console.ConfigEditorProcessor;
import io.quarkus.vertx.http.runtime.devmode.ConfigDescription;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Expressions;
import io.smallrye.config.SmallRyeConfig;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ConfigurationProcessor {
    private static final String QUOTED_DOT = "\".\"";
    private static final String QUOTED_DOT_KEY = "$$QUOTED_DOT$$";
    private static final Pattern codePattern = Pattern.compile("(\\{@code )([^}]+)(\\})");
    private static final Pattern linkPattern = Pattern.compile("(\\{@link )([^}]+)(\\})");

    @BuildStep(onlyIf={IsDevelopment.class})
    InternalPageBuildItem createConfigurationPages(List<ConfigDescriptionBuildItem> configDescriptionBuildItems, Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig) {
        InternalPageBuildItem configurationPages = new InternalPageBuildItem("Configuration", 20);
        configurationPages.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().namespace("devui-configuration")).title("Form Editor")).icon("font-awesome-solid:sliders")).componentLink("qwc-configuration.js"));
        configurationPages.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().namespace("devui-configuration")).title("Source Editor")).icon("font-awesome-solid:code")).componentLink("qwc-configuration-editor.js"));
        configurationPages.addBuildTimeData("allConfiguration", this.getAllConfig(configDescriptionBuildItems, devServicesLauncherConfig));
        return configurationPages;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    JsonRPCProvidersBuildItem registerJsonRpcService() {
        DevConsoleManager.register((String)"config-update-property", map -> {
            Map<String, String> values = Collections.singletonMap((String)map.get("name"), (String)map.get("value"));
            ConfigEditorProcessor.updateConfig(values, false);
            return null;
        });
        DevConsoleManager.register((String)"config-set-properties", value -> {
            String content = (String)value.get("content");
            ConfigEditorProcessor.setConfig(content, false);
            return null;
        });
        return new JsonRPCProvidersBuildItem("devui-configuration", ConfigJsonRPCService.class);
    }

    private List<ConfigDescription> getAllConfig(List<ConfigDescriptionBuildItem> configDescriptionBuildItems, Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig) {
        ArrayList<ConfigDescription> configDescriptions = new ArrayList<ConfigDescription>();
        for (ConfigDescriptionBuildItem item : configDescriptionBuildItems) {
            configDescriptions.add(new ConfigDescription(item.getPropertyName(), ConfigurationProcessor.formatJavadoc(ConfigEditorProcessor.cleanUpAsciiDocIfNecessary(item.getDocs())), item.getDefaultValue(), ConfigEditorProcessor.isSetByDevServices(devServicesLauncherConfig, item.getPropertyName()), item.getValueTypeName(), item.getAllowedValues(), item.getConfigPhase().name()));
        }
        HashSet<String> devServicesConfig = new HashSet<String>();
        if (devServicesLauncherConfig.isPresent()) {
            devServicesConfig.addAll(devServicesLauncherConfig.get().getConfig().keySet());
        }
        return this.calculate(configDescriptions, devServicesConfig);
    }

    /*
     * WARNING - void declaration
     */
    private List<ConfigDescription> calculate(List<ConfigDescription> cd, Set<String> devServicesProperties) {
        ArrayList<ConfigDescription> configDescriptions = new ArrayList<ConfigDescription>(cd);
        ArrayList<ConfigDescription> ordered = new ArrayList<ConfigDescription>();
        ArrayList<String> properties = new ArrayList<String>();
        SmallRyeConfig current = (SmallRyeConfig)ConfigProvider.getConfig();
        HashMap<List, Set> allPropertySegments = new HashMap<List, Set>();
        HashSet propertyNames = new HashSet();
        current.getPropertyNames().forEach(propertyNames::add);
        for (String propertyName : propertyNames) {
            propertyName = propertyName.replace(QUOTED_DOT, QUOTED_DOT_KEY);
            String[] parts = propertyName.split("\\.");
            ArrayList<String> accumulate = new ArrayList<String>();
            for (int i = 0; i < parts.length - 1 && !parts[i].isEmpty(); ++i) {
                if (parts[i].contains(QUOTED_DOT_KEY)) {
                    parts[i] = parts[i].replaceAll(QUOTED_DOT_KEY, QUOTED_DOT);
                }
                accumulate.add(parts[i]);
                Set potentialSegmentSet = allPropertySegments.computeIfAbsent(List.copyOf(accumulate), k -> new HashSet());
                if (this.isQuoted(parts[i + 1])) {
                    potentialSegmentSet.add(parts[i + 1]);
                    potentialSegmentSet.remove(parts[i + 1].substring(1, parts[i + 1].length() - 1));
                    continue;
                }
                if (potentialSegmentSet.contains(this.ensureQuoted(parts[i + 1]))) continue;
                potentialSegmentSet.add(parts[i + 1]);
            }
        }
        HashMap wildcardsToAdd = new HashMap();
        HashMap<String, Holder> foundItems = new HashMap<String, Holder>();
        HashSet<String> bannedExpansionCombos = new HashSet<String>();
        for (ConfigDescription configDescription : configDescriptions) {
            void var18_29;
            if (!configDescription.getName().contains("{*}")) {
                bannedExpansionCombos.add(configDescription.getName());
                for (int i = 0; i < configDescription.getName().length(); ++i) {
                    if (configDescription.getName().charAt(i) != '.') continue;
                    bannedExpansionCombos.add(configDescription.getName().substring(0, i));
                }
                properties.add(configDescription.getName());
                configDescription.setConfigValue(this.getConfigValue(current, configDescription.getName()));
                ordered.add(configDescription);
                continue;
            }
            if (configDescription.getName().startsWith("quarkus.log.filter")) continue;
            ArrayList<ArrayList<String>> componentParts = new ArrayList<ArrayList<String>>();
            ArrayList<String> accumulator = new ArrayList();
            String[] stringArray = configDescription.getName().split("\\.");
            int n = stringArray.length;
            boolean bl = false;
            while (var18_29 < n) {
                String i = stringArray[var18_29];
                if (i.equals("{*}")) {
                    componentParts.add(accumulator);
                    accumulator = new ArrayList<String>();
                } else {
                    accumulator.add(i);
                }
                ++var18_29;
            }
            HashMap building = new HashMap();
            building.put(List.of(), new HashSet());
            for (List list : componentParts) {
                HashMap newBuilding = new HashMap();
                for (Map.Entry entry : building.entrySet()) {
                    List attempt = (List)entry.getKey();
                    ArrayList newBase = new ArrayList(attempt);
                    newBase.addAll(list);
                    wildcardsToAdd.put(newBase, (Set)entry.getValue());
                    Set potential = (Set)allPropertySegments.get(newBase);
                    if (potential == null) continue;
                    bannedExpansionCombos.add(String.join((CharSequence)".", newBase).replace("\"", ""));
                    for (String definedName : potential) {
                        ArrayList<String> toAdd = new ArrayList<String>(newBase);
                        toAdd.add(definedName);
                        HashSet<CallSite> expansionKeys = new HashSet<CallSite>((Collection)entry.getValue());
                        expansionKeys.add((CallSite)((Object)(String.join((CharSequence)".", newBase) + "." + definedName)));
                        newBuilding.put(toAdd, expansionKeys);
                    }
                }
                building = newBuilding;
            }
            for (Map.Entry entry : building.entrySet()) {
                List segments = (List)entry.getKey();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < segments.size(); ++i) {
                    if (i > 0) {
                        sb.append(".");
                    }
                    sb.append((String)segments.get(i));
                }
                for (String s : accumulator) {
                    sb.append(".").append(s);
                }
                String expandedName = sb.toString();
                foundItems.put(expandedName, new Holder((Set)entry.getValue(), configDescription));
            }
        }
        for (Map.Entry entry : foundItems.entrySet()) {
            boolean ok = true;
            for (String key : ((Holder)entry.getValue()).expansionKeys) {
                if (!bannedExpansionCombos.contains(key)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            String expandedName = (String)entry.getKey();
            ConfigDescription item = ((Holder)entry.getValue()).configDescription;
            ConfigDescription newDesc = new ConfigDescription(expandedName, item.getDescription(), item.getDefaultValue(), devServicesProperties.contains(expandedName), item.getTypeName(), item.getAllowedValues(), item.getConfigPhase());
            properties.add(newDesc.getName());
            newDesc.setConfigValue(this.getConfigValue(current, newDesc.getName()));
            ordered.add(newDesc);
        }
        for (Map.Entry entry : wildcardsToAdd.entrySet()) {
            boolean ok = true;
            for (String key : (Set)entry.getValue()) {
                if (!bannedExpansionCombos.contains(key)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            List segments = (List)entry.getKey();
            StringBuilder sb = new StringBuilder();
            for (String string : segments) {
                sb.append(string);
                sb.append(".");
            }
            String expandedName = sb.toString();
            ConfigDescription configDescription = new ConfigDescription(expandedName, true);
            properties.add(configDescription.getName());
            configDescription.setConfigValue(this.getConfigValue(current, configDescription.getName()));
            ordered.add(configDescription);
        }
        for (ConfigSource configSource : current.getConfigSources()) {
            if (!configSource.getName().equals("PropertiesConfigSource[source=Build system]")) continue;
            properties.addAll(configSource.getPropertyNames());
        }
        Expressions.withoutExpansion(() -> {
            for (String propertyName : current.getPropertyNames()) {
                if (properties.contains(propertyName)) continue;
                ConfigDescription item = new ConfigDescription(propertyName, null, null, this.getConfigValue(current, propertyName));
                ordered.add(item);
                configDescriptions.add(item);
            }
        });
        return ordered;
    }

    private ConfigValue getConfigValue(SmallRyeConfig config, String name) {
        try {
            return config.getConfigValue(name);
        }
        catch (NoSuchElementException nse) {
            return null;
        }
    }

    private String ensureQuoted(String part) {
        if (this.isQuoted(part)) {
            return part;
        }
        return "\"" + part + "\"";
    }

    private boolean isQuoted(String part) {
        return part.length() >= 2 && part.charAt(0) == '\"' && part.charAt(part.length() - 1) == '\"';
    }

    static String formatJavadoc(String val) {
        if (val == null) {
            return val;
        }
        val = codePattern.matcher(val).replaceAll("<code>$2</code>");
        val = linkPattern.matcher(val).replaceAll("<code>$2</code>");
        val = val.lines().filter(s -> !s.startsWith("@see")).collect(Collectors.joining("\n"));
        val = val.replace("@deprecated", "<br><strong>Deprecated</strong>");
        return val;
    }

    static class Holder {
        final Set<String> expansionKeys;
        final ConfigDescription configDescription;

        private Holder(Set<String> expansionKeys, ConfigDescription configDescription) {
            this.expansionKeys = expansionKeys;
            this.configDescription = configDescription;
        }
    }
}

