/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.executor;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import io.shardingsphere.core.constant.ConnectionMode;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.executor.ShardingExecuteGroup;
import io.shardingsphere.core.executor.StatementExecuteUnit;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteCallback;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorExceptionHandler;
import io.shardingsphere.core.executor.sql.prepare.SQLExecutePrepareCallback;
import io.shardingsphere.core.routing.BatchRouteUnit;
import io.shardingsphere.core.routing.RouteUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.shardingjdbc.executor.AbstractStatementExecutor;
import io.shardingsphere.shardingjdbc.jdbc.core.connection.ShardingConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class BatchPreparedStatementExecutor
extends AbstractStatementExecutor {
    private final Collection<BatchRouteUnit> routeUnits = new LinkedList<BatchRouteUnit>();
    private final boolean returnGeneratedKeys;
    private int batchCount;

    public BatchPreparedStatementExecutor(int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean returnGeneratedKeys, ShardingConnection shardingConnection) {
        super(resultSetType, resultSetConcurrency, resultSetHoldability, shardingConnection);
        this.returnGeneratedKeys = returnGeneratedKeys;
    }

    public void init() throws SQLException {
        this.getExecuteGroups().addAll(this.obtainExecuteGroups(this.routeUnits));
    }

    private Collection<ShardingExecuteGroup<StatementExecuteUnit>> obtainExecuteGroups(Collection<BatchRouteUnit> routeUnits) throws SQLException {
        return this.getSqlExecutePrepareTemplate().getExecuteUnitGroups((Collection)Lists.transform(new ArrayList<BatchRouteUnit>(routeUnits), (Function)new Function<BatchRouteUnit, RouteUnit>(){

            public RouteUnit apply(BatchRouteUnit input) {
                return input.getRouteUnit();
            }
        }), new SQLExecutePrepareCallback(){

            public List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
                return BatchPreparedStatementExecutor.super.getConnection().getConnections(connectionMode, dataSourceName, connectionSize);
            }

            public StatementExecuteUnit createStatementExecuteUnit(Connection connection, RouteUnit routeUnit, ConnectionMode connectionMode) throws SQLException {
                return new StatementExecuteUnit(routeUnit, (Statement)BatchPreparedStatementExecutor.this.createPreparedStatement(connection, routeUnit.getSqlUnit().getSql()), connectionMode);
            }
        });
    }

    private PreparedStatement createPreparedStatement(Connection connection, String sql) throws SQLException {
        return this.returnGeneratedKeys ? connection.prepareStatement(sql, 1) : connection.prepareStatement(sql, this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability());
    }

    public void addBatchForRouteUnits(SQLRouteResult routeResult) {
        this.setSqlType(routeResult.getSqlStatement().getType());
        this.handleOldRouteUnits(this.createBatchRouteUnits(routeResult.getRouteUnits()));
        this.handleNewRouteUnits(this.createBatchRouteUnits(routeResult.getRouteUnits()));
        ++this.batchCount;
    }

    private Collection<BatchRouteUnit> createBatchRouteUnits(Collection<RouteUnit> routeUnits) {
        LinkedList<BatchRouteUnit> result = new LinkedList<BatchRouteUnit>();
        for (RouteUnit each : routeUnits) {
            result.add(new BatchRouteUnit(each));
        }
        return result;
    }

    private void handleOldRouteUnits(Collection<BatchRouteUnit> newRouteUnits) {
        for (final BatchRouteUnit each : newRouteUnits) {
            Optional batchRouteUnitOptional = Iterators.tryFind(this.routeUnits.iterator(), (Predicate)new Predicate<BatchRouteUnit>(){

                public boolean apply(BatchRouteUnit input) {
                    return input.equals((Object)each);
                }
            });
            if (!batchRouteUnitOptional.isPresent()) continue;
            this.reviseBatchRouteUnit((BatchRouteUnit)batchRouteUnitOptional.get(), each);
        }
    }

    private void reviseBatchRouteUnit(BatchRouteUnit oldBatchRouteUnit, BatchRouteUnit newBatchRouteUnit) {
        oldBatchRouteUnit.getRouteUnit().getSqlUnit().getParameterSets().add(newBatchRouteUnit.getRouteUnit().getSqlUnit().getParameterSets().get(0));
        oldBatchRouteUnit.mapAddBatchCount(this.batchCount);
    }

    private void handleNewRouteUnits(Collection<BatchRouteUnit> newRouteUnits) {
        newRouteUnits.removeAll(this.routeUnits);
        for (BatchRouteUnit each : newRouteUnits) {
            each.mapAddBatchCount(this.batchCount);
        }
        this.routeUnits.addAll(newRouteUnits);
    }

    public int[] executeBatch() throws SQLException {
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        SQLExecuteCallback<int[]> callback = new SQLExecuteCallback<int[]>(this.getDatabaseType(), this.getSqlType(), isExceptionThrown){

            protected int[] executeSQL(StatementExecuteUnit statementExecuteUnit) throws SQLException {
                return statementExecuteUnit.getStatement().executeBatch();
            }
        };
        return this.accumulate(this.executeCallback(callback));
    }

    private int[] accumulate(List<int[]> results) {
        int[] result = new int[this.batchCount];
        int count = 0;
        for (BatchRouteUnit each : this.routeUnits) {
            for (Map.Entry entry : each.getJdbcAndActualAddBatchCallTimesMap().entrySet()) {
                int value;
                int n = value = null == results.get(count) ? 0 : results.get(count)[(Integer)entry.getValue()];
                if (DatabaseType.Oracle == this.getDatabaseType()) {
                    result[((Integer)entry.getKey()).intValue()] = value;
                    continue;
                }
                int n2 = (Integer)entry.getKey();
                result[n2] = result[n2] + value;
            }
            ++count;
        }
        return result;
    }

    @Override
    public List<Statement> getStatements() {
        LinkedList<Statement> result = new LinkedList<Statement>();
        for (ShardingExecuteGroup<StatementExecuteUnit> each : this.getExecuteGroups()) {
            result.addAll(Lists.transform((List)each.getInputs(), (Function)new Function<StatementExecuteUnit, Statement>(){

                public Statement apply(StatementExecuteUnit input) {
                    return input.getStatement();
                }
            }));
        }
        return result;
    }

    public List<List<Object>> getParameterSet(final Statement statement) {
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        for (ShardingExecuteGroup<StatementExecuteUnit> each : this.getExecuteGroups()) {
            Optional target = Iterators.tryFind(each.getInputs().iterator(), (Predicate)new Predicate<StatementExecuteUnit>(){

                public boolean apply(StatementExecuteUnit input) {
                    return input.getStatement().equals(statement);
                }
            });
            if (!target.isPresent()) continue;
            result.addAll(((StatementExecuteUnit)target.get()).getRouteUnit().getSqlUnit().getParameterSets());
            break;
        }
        return result;
    }

    @Override
    public void clear() throws SQLException {
        super.clear();
        this.batchCount = 0;
        this.routeUnits.clear();
    }

    public boolean isReturnGeneratedKeys() {
        return this.returnGeneratedKeys;
    }
}

