/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.uni.builders.UniJoinAll;
import io.smallrye.mutiny.operators.uni.builders.UniJoinFirst;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Experimental(value="New API based on observations that Uni.combine() is often used with homogeneous types, and combination often just a mapping to a collection.")
public class UniJoin {
    public static final UniJoin SHARED_INSTANCE = new UniJoin();

    private UniJoin() {
    }

    @SafeVarargs
    @CheckReturnValue
    public final <T> JoinAllStrategy<T> all(Uni<T> ... unis) {
        return this.all(Arrays.asList(ParameterValidation.nonNull(unis, "unis")));
    }

    @CheckReturnValue
    public final <T> JoinAllStrategy<T> all(List<Uni<T>> unis) {
        ParameterValidation.doesNotContainNull(unis, "unis");
        ParameterValidation.isNotEmpty(unis, "unis");
        return new JoinAllStrategy(unis);
    }

    @SafeVarargs
    @CheckReturnValue
    public final <T> JoinFirstStrategy<T> first(Uni<T> ... unis) {
        return this.first(Arrays.asList(ParameterValidation.nonNull(unis, "unis")));
    }

    @CheckReturnValue
    public final <T> JoinFirstStrategy<T> first(List<Uni<T>> unis) {
        ParameterValidation.doesNotContainNull(unis, "unis");
        ParameterValidation.isNotEmpty(unis, "unis");
        return new JoinFirstStrategy(unis);
    }

    @CheckReturnValue
    public <T> Builder<T> builder() {
        return new Builder();
    }

    public class Builder<T> {
        private final List<Uni<T>> unis = new ArrayList<Uni<T>>();

        @CheckReturnValue
        public Builder<T> add(Uni<T> uni) {
            this.unis.add(uni);
            return this;
        }

        @CheckReturnValue
        public JoinAllStrategy<T> joinAll() {
            return UniJoin.this.all(this.unis);
        }

        @CheckReturnValue
        public JoinFirstStrategy<T> joinFirst() {
            return UniJoin.this.first(this.unis);
        }
    }

    public static class JoinFirstStrategy<T> {
        private final List<Uni<T>> unis;

        private JoinFirstStrategy(List<Uni<T>> unis) {
            this.unis = unis;
        }

        @CheckReturnValue
        public Uni<T> toTerminate() {
            return Infrastructure.onUniCreation(new UniJoinFirst<T>(this.unis, UniJoinFirst.Mode.FIRST_TO_EMIT));
        }

        @CheckReturnValue
        public Uni<T> withItem() {
            return Infrastructure.onUniCreation(new UniJoinFirst<T>(this.unis, UniJoinFirst.Mode.FIRST_WITH_ITEM));
        }
    }

    public static class JoinAllStrategy<T> {
        private final List<Uni<T>> unis;

        private JoinAllStrategy(List<Uni<T>> unis) {
            this.unis = unis;
        }

        @CheckReturnValue
        public Uni<List<T>> andCollectFailures() {
            return Infrastructure.onUniCreation(new UniJoinAll<T>(this.unis, UniJoinAll.Mode.COLLECT_FAILURES));
        }

        @CheckReturnValue
        public Uni<List<T>> andFailFast() {
            return Infrastructure.onUniCreation(new UniJoinAll<T>(this.unis, UniJoinAll.Mode.FAIL_FAST));
        }
    }
}

