/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.internal;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import mutiny.zero.internal.AlreadyCompletedSubscription;
import mutiny.zero.internal.Helper;

public class CompletionStagePublisher<T>
implements Flow.Publisher<T> {
    private final Supplier<CompletionStage<T>> completionStageSupplier;

    public CompletionStagePublisher(Supplier<CompletionStage<T>> completionStageSupplier) {
        this.completionStageSupplier = completionStageSupplier;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        block7: {
            Objects.requireNonNull(subscriber, "The subscriber cannot be null");
            CompletionStage<T> cs = this.completionStageSupplier.get();
            if (cs == null) {
                subscriber.onSubscribe(new AlreadyCompletedSubscription());
                subscriber.onError(new NullPointerException("The completion stage is null"));
                return;
            }
            CompletableFuture<T> completableFuture = cs.toCompletableFuture();
            if (completableFuture.isDone()) {
                subscriber.onSubscribe(new AlreadyCompletedSubscription());
                try {
                    T value = completableFuture.get();
                    if (value == null) {
                        subscriber.onError(new NullPointerException("The CompletionStage produced a null value"));
                        break block7;
                    }
                    subscriber.onNext(value);
                    subscriber.onComplete();
                }
                catch (InterruptedException e) {
                    subscriber.onError(e);
                }
                catch (ExecutionException e) {
                    subscriber.onError(e.getCause());
                }
            } else {
                subscriber.onSubscribe(new CompletionStageSubscription(subscriber, completableFuture));
            }
        }
    }

    private class CompletionStageSubscription
    implements Flow.Subscription {
        private final Flow.Subscriber<? super T> subscriber;
        private final CompletableFuture<T> completableFuture;
        private final AtomicBoolean cancelled = new AtomicBoolean();

        private CompletionStageSubscription(Flow.Subscriber<? super T> subscriber, CompletableFuture<T> completableFuture) {
            this.subscriber = subscriber;
            this.completableFuture = completableFuture;
        }

        @Override
        public void request(long n) {
            if (this.cancelled.get()) {
                return;
            }
            if (n <= 0L) {
                this.cancel();
                this.subscriber.onError(Helper.negativeRequest(n));
            } else {
                this.completableFuture.whenComplete((value, err) -> {
                    if (this.cancelled.compareAndSet(false, true)) {
                        if (err != null) {
                            this.subscriber.onError((Throwable)err);
                        } else if (value == null) {
                            this.subscriber.onError(new NullPointerException("The CompletionStage produced a null value"));
                        } else {
                            this.subscriber.onNext(value);
                            this.subscriber.onComplete();
                        }
                    }
                });
            }
        }

        @Override
        public void cancel() {
            this.cancelled.set(false);
            this.completableFuture.toCompletableFuture().cancel(false);
        }
    }
}

