/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl.wrappers;

import io.smallrye.context.CleanAutoCloseable;
import io.smallrye.context.impl.CapturedContextState;
import io.smallrye.context.impl.Contextualized;
import java.util.function.Supplier;

public final class SlowContextualSupplier<R>
implements Supplier<R>,
Contextualized {
    private final CapturedContextState state;
    private final Supplier<R> supplier;

    public SlowContextualSupplier(CapturedContextState state, Supplier<R> supplier) {
        this.state = state;
        this.supplier = supplier;
    }

    @Override
    public R get() {
        try (CleanAutoCloseable activeState = this.state.begin();){
            R r = this.supplier.get();
            return r;
        }
    }
}

