package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Bulkhead;

/**
 * Automatically generated from the {@link BulkheadConfig} config interface, do not modify.
 */
public final class BulkheadConfigImpl implements BulkheadConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final Bulkhead instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Cached value of the {@code Bulkhead.value} annotation member; {@code null} if not looked up yet.
     */
    private Integer _value;

    /**
     * Cached value of the {@code Bulkhead.waitingTaskQueue} annotation member; {@code null} if not looked up yet.
     */
    private Integer _waitingTaskQueue;

    private BulkheadConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.bulkhead;
        this.onMethod = method.annotationsPresentDirectly.contains(Bulkhead.class);
    }

    public static BulkheadConfigImpl create(FaultToleranceMethod method) {
        if (method.bulkhead == null) {
            return null;
        }
        if (!Config.isEnabled(Bulkhead.class, method.method)) {
            return null;
        }
        return new BulkheadConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Bulkhead.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public int value() {
        if (_value == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _value = config.getOptionalValue(getConfigKeyForMethod("value"), int.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _value = config.getOptionalValue(getConfigKeyForClass("value"), int.class).orElse(null);
            }
            if (_value == null) {
                // <annotation>/<parameter>
                _value = config.getOptionalValue("Bulkhead" + "/" + "value", int.class).orElse(null);
            }
            if (_value == null) {
                // annotation value
                _value = instance.value();
            }
        }
        return _value;
    }

    @Override
    public int waitingTaskQueue() {
        if (_waitingTaskQueue == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _waitingTaskQueue = config.getOptionalValue(getConfigKeyForMethod("waitingTaskQueue"), int.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _waitingTaskQueue = config.getOptionalValue(getConfigKeyForClass("waitingTaskQueue"), int.class).orElse(null);
            }
            if (_waitingTaskQueue == null) {
                // <annotation>/<parameter>
                _waitingTaskQueue = config.getOptionalValue("Bulkhead" + "/" + "waitingTaskQueue", int.class).orElse(null);
            }
            if (_waitingTaskQueue == null) {
                // annotation value
                _waitingTaskQueue = instance.waitingTaskQueue();
            }
        }
        return _waitingTaskQueue;
    }

    private String getConfigKeyForMethod(String key) {
        return method.declaringClass.getName() + "/" + method.name + "/" + "Bulkhead" + "/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return method.declaringClass.getName() + "/" + "Bulkhead" + "/" + key;
    }
}
