package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.CustomBackoff;
import io.smallrye.faulttolerance.api.CustomBackoffStrategy;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.ConfigProvider;

/**
 * Automatically generated from the {@link CustomBackoffConfig} config interface, do not modify.
 */
public final class CustomBackoffConfigImpl implements CustomBackoffConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final CustomBackoff instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Cached value of the {@code CustomBackoff.value} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends CustomBackoffStrategy> _value;

    private CustomBackoffConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.customBackoff;
        this.onMethod = method.annotationsPresentDirectly.contains(CustomBackoff.class);
    }

    public static CustomBackoffConfigImpl create(FaultToleranceMethod method) {
        if (method.customBackoff == null) {
            return null;
        }
        if (!Config.isEnabled(CustomBackoff.class, method.method)) {
            return null;
        }
        return new CustomBackoffConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return CustomBackoff.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public Class<? extends CustomBackoffStrategy> value() {
        if (_value == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _value = config.getOptionalValue(getConfigKeyForMethod("value"), Class.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _value = config.getOptionalValue(getConfigKeyForClass("value"), Class.class).orElse(null);
            }
            if (_value == null) {
                // <annotation>/<parameter>
                _value = config.getOptionalValue("CustomBackoff" + "/" + "value", Class.class).orElse(null);
            }
            if (_value == null) {
                // annotation value
                _value = instance.value();
            }
        }
        return _value;
    }

    private String getConfigKeyForMethod(String key) {
        return method.declaringClass.getName() + "/" + method.name + "/" + "CustomBackoff" + "/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return method.declaringClass.getName() + "/" + "CustomBackoff" + "/" + key;
    }
}
