/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.api;

import io.smallrye.common.annotation.Experimental;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Experimental(value="Request context to allow downstream operations to get insight into the request. Not covered by the specification. Subject to change.")
public interface Context {
    public static final String QUERY = "query";
    public static final String OPERATION_NAME = "operationName";
    public static final String VARIABLES = "variables";

    public JsonObject getRequest();

    default public boolean hasRequest() {
        JsonObject request = this.getRequest();
        return request != null;
    }

    default public String getQuery() {
        return this.getRequest().getString(QUERY, null);
    }

    public Optional<String> getOperationName();

    default public boolean hasOperationName() {
        return this.getOperationName().isPresent();
    }

    default public Optional<Map<String, Object>> getVariables() {
        if (this.getRequest().containsKey((Object)VARIABLES) && this.getRequest().get((Object)VARIABLES) != null && !((JsonValue)this.getRequest().get((Object)VARIABLES)).getValueType().equals((Object)JsonValue.ValueType.NULL)) {
            JsonValue jsonValue = (JsonValue)this.getRequest().get((Object)VARIABLES);
            return VariablesParser.toMap(jsonValue);
        }
        return Optional.empty();
    }

    default public boolean hasVariables() {
        return this.getVariables().isPresent();
    }

    public String getExecutionId();

    public String getFieldName();

    default public <A> Boolean hasArgument(String name) {
        Map<String, A> arguments = this.getArguments();
        if (arguments != null) {
            return arguments.containsKey(name);
        }
        return null;
    }

    default public <A> A getArgument(String name) {
        Map<String, A> arguments = this.getArguments();
        if (arguments != null) {
            return arguments.get(name);
        }
        return null;
    }

    default public <A> A getArgumentOrDefault(String name, A defaultValue) {
        A arg = this.getArgument(name);
        if (arg == null) {
            return defaultValue;
        }
        return arg;
    }

    public <A> Map<String, A> getArguments();

    default public boolean hasSource() {
        Object o = this.getSource();
        return o != null;
    }

    public <S> S getSource();

    public String getPath();

    public JsonArray getSelectedFields();

    public JsonArray getSelectedAndSourceFields();

    public String getOperationType();

    public List<String> getRequestedOperationTypes();

    public Optional<String> getParentTypeName();

    public <T> T unwrap(Class<T> var1);

    public static class VariablesParser {
        public static Optional<Map<String, Object>> toMap(JsonValue jsonValue) {
            if (!(null == jsonValue || JsonValue.NULL.equals(jsonValue) || JsonValue.EMPTY_JSON_OBJECT.equals(jsonValue) || JsonValue.EMPTY_JSON_ARRAY.equals(jsonValue))) {
                return Optional.of(VariablesParser.toMap(jsonValue.asJsonObject()));
            }
            return Optional.empty();
        }

        private static Map<String, Object> toMap(JsonObject jo) {
            HashMap<String, Object> ro = new HashMap<String, Object>();
            if (jo != null) {
                Set entrySet = jo.entrySet();
                for (Map.Entry es : entrySet) {
                    ro.put((String)es.getKey(), VariablesParser.toObject((JsonValue)es.getValue()));
                }
            }
            return ro;
        }

        private static Object toObject(JsonValue jsonValue) {
            Object ret = null;
            JsonValue.ValueType typ = jsonValue.getValueType();
            if (null != typ) {
                switch (typ) {
                    case NUMBER: {
                        ret = ((JsonNumber)jsonValue).bigDecimalValue();
                        break;
                    }
                    case STRING: {
                        ret = ((JsonString)jsonValue).getString();
                        break;
                    }
                    case FALSE: {
                        ret = Boolean.FALSE;
                        break;
                    }
                    case TRUE: {
                        ret = Boolean.TRUE;
                        break;
                    }
                    case ARRAY: {
                        JsonArray arr = (JsonArray)jsonValue;
                        ArrayList<Object> vals = new ArrayList<Object>();
                        int sz = arr.size();
                        for (int i = 0; i < sz; ++i) {
                            JsonValue v = (JsonValue)arr.get(i);
                            vals.add(VariablesParser.toObject(v));
                        }
                        ret = vals;
                        break;
                    }
                    case OBJECT: {
                        ret = VariablesParser.toMap((JsonObject)jsonValue);
                        break;
                    }
                }
            }
            return ret;
        }
    }
}

