/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentracing.contrib.jaxrs2.server;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.smallrye.opentracing.contrib.jaxrs2.internal.CastUtils;
import io.smallrye.opentracing.contrib.jaxrs2.internal.SpanWrapper;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;

public class SpanFinishingFilter
implements Filter {
    public SpanFinishingFilter() {
    }

    @Deprecated
    public SpanFinishingFilter(Tracer tracer) {
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        try {
            chain.doFilter(request, response);
        }
        catch (Exception ex) {
            SpanWrapper spanWrapper = this.getSpanWrapper(httpRequest);
            if (spanWrapper != null) {
                Tags.HTTP_STATUS.set(spanWrapper.get(), Integer.valueOf(httpResponse.getStatus()));
                SpanFinishingFilter.addExceptionLogs(spanWrapper.get(), ex);
            }
            throw ex;
        }
        finally {
            SpanWrapper spanWrapper = this.getSpanWrapper(httpRequest);
            if (spanWrapper != null) {
                spanWrapper.getScope().close();
                if (request.isAsyncStarted()) {
                    request.getAsyncContext().addListener((AsyncListener)new SpanFinisher(spanWrapper), request, response);
                } else {
                    spanWrapper.finish();
                }
            }
        }
    }

    private SpanWrapper getSpanWrapper(HttpServletRequest request) {
        return CastUtils.cast(request.getAttribute(SpanWrapper.PROPERTY_NAME), SpanWrapper.class);
    }

    public void destroy() {
    }

    private static void addExceptionLogs(Span span, Throwable throwable) {
        Tags.ERROR.set(span, Boolean.valueOf(true));
        if (throwable != null) {
            HashMap<String, Object> errorLogs = new HashMap<String, Object>(2);
            errorLogs.put("event", Tags.ERROR.getKey());
            errorLogs.put("error.object", throwable);
            span.log(errorLogs);
        }
    }

    static class SpanFinisher
    implements AsyncListener {
        private SpanWrapper spanWrapper;

        SpanFinisher(SpanWrapper spanWrapper) {
            this.spanWrapper = spanWrapper;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            HttpServletResponse httpResponse = (HttpServletResponse)event.getSuppliedResponse();
            if (httpResponse.getStatus() >= 500) {
                SpanFinishingFilter.addExceptionLogs(this.spanWrapper.get(), event.getThrowable());
            }
            Tags.HTTP_STATUS.set(this.spanWrapper.get(), Integer.valueOf(httpResponse.getStatus()));
            this.spanWrapper.finish();
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }
    }
}

