/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl.attestation.tpm;

import io.vertx.core.buffer.Buffer;

public class CertInfo {
    public static final long TPM_GENERATED = 4283712327L;
    private final long magic;
    private final int type;
    private final byte[] qualifiedSigner;
    private final byte[] extraData;
    private final byte[] clockInfo;
    private final byte[] firmwareVersion;
    private final byte[] attestedName;
    private final int nameAlg;
    private final byte[] qualifiedName;

    public CertInfo(byte[] data) {
        this(Buffer.buffer((byte[])data));
    }

    public CertInfo(Buffer certBuffer) {
        int pos = 0;
        this.magic = certBuffer.getUnsignedInt(pos);
        this.type = certBuffer.getUnsignedShort(pos += 4);
        int len = certBuffer.getUnsignedShort(pos += 2);
        this.qualifiedSigner = certBuffer.getBytes(pos += 2, pos + len);
        pos += len;
        len = certBuffer.getUnsignedShort(pos);
        this.extraData = certBuffer.getBytes(pos += 2, pos + len);
        this.clockInfo = certBuffer.getBytes(pos += len, pos + 17);
        this.firmwareVersion = certBuffer.getBytes(pos += 17, pos + 8);
        len = certBuffer.getUnsignedShort(pos += 8);
        this.attestedName = certBuffer.getBytes(pos += 2, pos + len);
        this.nameAlg = certBuffer.getUnsignedShort(pos);
        pos += len;
        len = certBuffer.getUnsignedShort(pos);
        this.qualifiedName = certBuffer.getBytes(pos += 2, pos + len);
    }

    public long getMagic() {
        return this.magic;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getQualifiedSigner() {
        return this.qualifiedSigner;
    }

    public byte[] getExtraData() {
        return this.extraData;
    }

    public byte[] getClockInfo() {
        return this.clockInfo;
    }

    public byte[] getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public byte[] getAttestedName() {
        return this.attestedName;
    }

    public byte[] getQualifiedName() {
        return this.qualifiedName;
    }

    public int getNameAlg() {
        return this.nameAlg;
    }
}

