/*
 * Decompiled with CFR 0.152.
 */
package javancss;

import ccl.util.Exitable;
import ccl.util.FileUtil;
import ccl.util.Init;
import ccl.util.Test;
import ccl.util.Util;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javancss.AsciiFormatter;
import javancss.Formatter;
import javancss.JavaParser;
import javancss.JavaParserTokenManager;
import javancss.JavancssConstants;
import javancss.JavancssFrame;
import javancss.PackageMetric;
import javancss.ParseException;
import javancss.TokenMgrError;
import javancss.XmlFormatter;
import javancss.test.JavancssTest;

public class Javancss
implements Exitable,
JavancssConstants {
    static final int LEN_NR = 3;
    static final String S_INIT__FILE_CONTENT = "[Init]\nAuthor=Chr. Clemens Lee\n\n[Help]\n; Please do not edit the Help section\nHelpUsage=@srcfiles.txt | *.java | <stdin>\nOptions=ncss,package,object,function,all,gui,xml,out,recursive,check\nncss=b,o,Counts the program NCSS (default).\npackage=b,o,Assembles a statistic on package level.\nobject=b,o,Counts the object NCSS.\nfunction=b,o,Counts the function NCSS.\nall=b,o,The same as '-function -object -package'.\ngui=b,o,Opens a gui to present the '-all' output in tabbed panels.\nxml=b,o,Output in xml format.\nout=s,o,Output file name. By default output goes to standard out.\nrecursive=b,o,Recurse to subdirs.\ncheck=b,o,Triggers a javancss self test.\n\n[Colors]\nUseSystemColors=true\n";
    private boolean _bExit = false;
    private int _ncss = 0;
    private int _loc = 0;
    private JavaParser _pJavaParser = null;
    private Vector _vJavaSourceFiles = new Vector();
    private String _sErrorMessage = null;
    private Throwable _thrwError = null;
    private Vector _vFunctionMetrics = new Vector();
    private Vector _vObjectMetrics = new Vector();
    private Vector _vPackageMetrics = null;
    private Vector _vImports = null;
    private Hashtable _htPackages = null;
    private Hashtable _htProcessedAtFiles = new Hashtable();
    private Object[] _aoPackage = null;
    private String _sJavaSourceFileName = null;
    private Init _pInit = null;
    private boolean _bXML = false;

    private DataInputStream createInputStream(String sSourceFileName_) {
        DataInputStream disSource = null;
        try {
            disSource = new DataInputStream(new FileInputStream(sSourceFileName_));
        }
        catch (IOException pIOException) {
            this._sErrorMessage = Util.isEmpty((String)this._sErrorMessage) ? "" : this._sErrorMessage + "\n";
            this._sErrorMessage = this._sErrorMessage + "File not found: " + sSourceFileName_;
            this._thrwError = pIOException;
            return null;
        }
        return disSource;
    }

    private void _measureSource(String sSourceFileName_) throws IOException, ParseException, TokenMgrError {
        sSourceFileName_ = FileUtil.normalizeFileName((String)sSourceFileName_);
        DataInputStream disSource = null;
        try {
            disSource = new DataInputStream(new FileInputStream(sSourceFileName_));
        }
        catch (IOException pIOException) {
            this._sErrorMessage = Util.isEmpty((String)this._sErrorMessage) ? "" : this._sErrorMessage + "\n";
            this._sErrorMessage = this._sErrorMessage + "File not found: " + sSourceFileName_;
            this._thrwError = pIOException;
            throw pIOException;
        }
        String sTempErrorMessage = this._sErrorMessage;
        try {
            this._measureSource(disSource);
        }
        catch (ParseException pParseException) {
            if (sTempErrorMessage == null) {
                sTempErrorMessage = "";
            }
            sTempErrorMessage = sTempErrorMessage + "ParseException in " + sSourceFileName_ + "\nLast useful checkpoint: \"" + this._pJavaParser.getLastFunction() + "\"\n";
            this._sErrorMessage = sTempErrorMessage = sTempErrorMessage + pParseException.getMessage() + "\n";
            this._thrwError = pParseException;
            throw pParseException;
        }
        catch (TokenMgrError pTokenMgrError) {
            if (sTempErrorMessage == null) {
                sTempErrorMessage = "";
            }
            this._sErrorMessage = sTempErrorMessage = sTempErrorMessage + "TokenMgrError in " + sSourceFileName_ + "\n" + pTokenMgrError.getMessage() + "\n";
            this._thrwError = pTokenMgrError;
            throw pTokenMgrError;
        }
    }

    private void _measureSource(DataInputStream disSource_) throws IOException, ParseException, TokenMgrError {
        try {
            this._pJavaParser = new JavaParser(disSource_);
            this._pJavaParser.CompilationUnit();
            Util.debug((Object)"Javancss._measureSource(DataInputStream).SUCCESSFULLY_PARSED");
            this._ncss += this._pJavaParser.getNcss();
            this._loc += this._pJavaParser.getLOC();
            this._vFunctionMetrics = Util.concat((Vector)this._vFunctionMetrics, (Vector)this._pJavaParser.getFunction());
            this._vObjectMetrics = Util.concat((Vector)this._vObjectMetrics, (Vector)this._pJavaParser.getObject());
            Hashtable htNewPackages = this._pJavaParser.getPackage();
            Vector vNewPackages = new Vector();
            Enumeration ePackages = htNewPackages.keys();
            while (ePackages.hasMoreElements()) {
                String sPackage = (String)ePackages.nextElement();
                PackageMetric pckmNext = (PackageMetric)htNewPackages.get(sPackage);
                pckmNext.name = sPackage;
                PackageMetric pckmPrevious = (PackageMetric)this._htPackages.get(sPackage);
                pckmNext.add(pckmPrevious);
                this._htPackages.put(sPackage, pckmNext);
            }
        }
        catch (ParseException pParseException) {
            if (this._sErrorMessage == null) {
                this._sErrorMessage = "";
            }
            this._sErrorMessage = this._sErrorMessage + "ParseException in STDIN";
            if (this._pJavaParser != null) {
                this._sErrorMessage = this._sErrorMessage + "\nLast useful checkpoint: \"" + this._pJavaParser.getLastFunction() + "\"\n";
            }
            this._sErrorMessage = this._sErrorMessage + pParseException.getMessage() + "\n";
            this._thrwError = pParseException;
            throw pParseException;
        }
        catch (TokenMgrError pTokenMgrError) {
            if (this._sErrorMessage == null) {
                this._sErrorMessage = "";
            }
            this._sErrorMessage = this._sErrorMessage + "TokenMgrError in STDIN\n";
            this._sErrorMessage = this._sErrorMessage + pTokenMgrError.getMessage() + "\n";
            this._thrwError = pTokenMgrError;
            throw pTokenMgrError;
        }
    }

    private void _measureFiles(Vector vJavaSourceFiles_) throws IOException, ParseException, TokenMgrError {
        Enumeration e = vJavaSourceFiles_.elements();
        while (e.hasMoreElements()) {
            String sJavaFileName = (String)e.nextElement();
            if (sJavaFileName.charAt(0) == '@') {
                if (sJavaFileName.length() <= 1) continue;
                String sFileName = sJavaFileName.substring(1);
                if (this._htProcessedAtFiles.get(sFileName = FileUtil.normalizeFileName((String)sFileName)) != null) continue;
                this._htProcessedAtFiles.put(sFileName, Util.getConstantObject());
                String sJavaSourceFileNames = null;
                try {
                    sJavaSourceFileNames = FileUtil.readFile((String)sFileName);
                }
                catch (IOException pIOException) {
                    this._sErrorMessage = "File Read Error: " + sFileName;
                    this._thrwError = pIOException;
                    throw pIOException;
                }
                Vector vTheseJavaSourceFiles = Util.stringToLines((String)sJavaSourceFileNames);
                this._measureFiles(vTheseJavaSourceFiles);
                continue;
            }
            try {
                this._measureSource(sJavaFileName);
            }
            catch (Throwable pThrowable) {
                // empty catch block
            }
        }
    }

    private void _measureRoot(InputStream pInputStream_) throws IOException, ParseException, TokenMgrError {
        this._htPackages = new Hashtable();
        if (this._vJavaSourceFiles.size() == 0) {
            DataInputStream disJava = new DataInputStream(pInputStream_);
            this._measureSource(disJava);
        } else {
            this._measureFiles(this._vJavaSourceFiles);
        }
        this._vPackageMetrics = new Vector();
        Enumeration ePackages = this._htPackages.keys();
        while (ePackages.hasMoreElements()) {
            String sPackage = (String)ePackages.nextElement();
            PackageMetric pckmNext = (PackageMetric)this._htPackages.get(sPackage);
            this._vPackageMetrics.addElement(pckmNext);
        }
        this._vPackageMetrics = Util.sort((Vector)this._vPackageMetrics);
    }

    public Vector getImports() {
        return this._vImports;
    }

    public Object[] getPackage() {
        return this._aoPackage;
    }

    public Vector getFunctions() {
        return this._vFunctionMetrics;
    }

    public String printObjectNcss() {
        return this.getFormatter().printObjectNcss();
    }

    public String printFunctionNcss() {
        return this.getFormatter().printFunctionNcss();
    }

    public String printPackageNcss() {
        return this.getFormatter().printPackageNcss();
    }

    public String printJavaNcss() {
        return this.getFormatter().printJavaNcss();
    }

    public Javancss(Vector vJavaSourceFiles_) {
        this._vJavaSourceFiles = vJavaSourceFiles_;
        try {
            this._measureRoot(System.in);
        }
        catch (Exception e) {
        }
        catch (TokenMgrError tokenMgrError) {
            // empty catch block
        }
    }

    public Javancss(String sJavaSourceFile_) {
        Util.debug((Object)("Javancss.<init>(String).sJavaSourceFile_: " + sJavaSourceFile_));
        this._sErrorMessage = null;
        this._vJavaSourceFiles = new Vector();
        this._vJavaSourceFiles.addElement(sJavaSourceFile_);
        try {
            this._measureRoot(System.in);
        }
        catch (Exception e) {
            Util.debug((Object)("Javancss.<init>(String).e: " + e));
        }
        catch (TokenMgrError pError) {
            Util.debug((Object)("Javancss.<init>(String).pError: " + pError));
        }
    }

    public Javancss() {
        this._sErrorMessage = null;
        this._thrwError = null;
    }

    public boolean parseImports() {
        if (Util.isEmpty((String)this._sJavaSourceFileName)) {
            Util.debug((Object)"Javancss.parseImports().NO_FILE");
            return true;
        }
        DataInputStream disSource = this.createInputStream(this._sJavaSourceFileName);
        if (disSource == null) {
            Util.debug((Object)"Javancss.parseImports().NO_DIS");
            return true;
        }
        try {
            Util.debug((Object)"Javancss.parseImports().START_PARSING");
            this._pJavaParser = new JavaParser(disSource);
            this._pJavaParser.ImportUnit();
            this._vImports = this._pJavaParser.getImports();
            this._aoPackage = this._pJavaParser.getPackageObjects();
            Util.debug((Object)"Javancss.parseImports().END_PARSING");
        }
        catch (ParseException pParseException) {
            Util.debug((Object)"Javancss.parseImports().PARSE_EXCEPTION");
            if (this._sErrorMessage == null) {
                this._sErrorMessage = "";
            }
            this._sErrorMessage = this._sErrorMessage + "ParseException in STDIN";
            if (this._pJavaParser != null) {
                this._sErrorMessage = this._sErrorMessage + "\nLast useful checkpoint: \"" + this._pJavaParser.getLastFunction() + "\"\n";
            }
            this._sErrorMessage = this._sErrorMessage + pParseException.getMessage() + "\n";
            this._thrwError = pParseException;
            return true;
        }
        catch (TokenMgrError pTokenMgrError) {
            Util.debug((Object)"Javancss.parseImports().TOKEN_ERROR");
            if (this._sErrorMessage == null) {
                this._sErrorMessage = "";
            }
            this._sErrorMessage = this._sErrorMessage + "TokenMgrError in STDIN\n";
            this._sErrorMessage = this._sErrorMessage + pTokenMgrError.getMessage() + "\n";
            this._thrwError = pTokenMgrError;
            return true;
        }
        return false;
    }

    public void setSourceFile(String sJavaSourceFile_) {
        this._sJavaSourceFileName = sJavaSourceFile_;
        this._vJavaSourceFiles = new Vector();
        this._vJavaSourceFiles.addElement(sJavaSourceFile_);
    }

    public Javancss(StringBufferInputStream pStringBufferInputStream_) {
        try {
            this._measureRoot(pStringBufferInputStream_);
        }
        catch (Exception e) {
        }
        catch (TokenMgrError tokenMgrError) {
            // empty catch block
        }
    }

    private void _addJavaFiles(File file, Vector v) {
        String sFile = FileUtil.normalizeFileName((String)file.getPath());
        String[] files = new File(sFile).list();
        if (files == null || files.length == 0) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            String newFileName = FileUtil.concatPath((String)sFile, (String)files[i]);
            File newFile = new File(newFileName);
            if (newFile.isDirectory()) {
                this._addJavaFiles(newFile, v);
            } else if (newFile.getAbsolutePath().endsWith(".java")) {
                v.addElement(newFile.getAbsolutePath());
            }
            ++i;
        }
    }

    private void _removeDirs(Vector vDirs) {
        if (Util.isDebug()) {
            Util.debug((Object)this, (Object)("_removeDirs(..).vDirs: " + Util.toString((Object)vDirs)));
        }
        int i = vDirs.size() - 1;
        while (i >= 0) {
            String sFile = FileUtil.normalizeFileName((String)((String)vDirs.elementAt(i)));
            Util.debug((Object)this, (Object)("_removeDirs(..).sFile: " + sFile));
            if (FileUtil.existsDir((String)sFile)) {
                vDirs.removeElementAt(i);
                Util.debug((Object)this, (Object)("_removeDirs(..).removed: " + sFile));
            }
            --i;
        }
    }

    public Javancss(String[] asArgs_, String sRcsHeader_) {
        this._pInit = new Init((Exitable)this, asArgs_, sRcsHeader_, S_INIT__FILE_CONTENT);
        if (this._bExit) {
            return;
        }
        Hashtable htOptions = this._pInit.getOptions();
        if (htOptions.get("check") != null) {
            JavancssTest pTest = new JavancssTest();
            pTest.setTestDir(FileUtil.concatPath((String)this._pInit.getApplicationPath(), (String)"test"));
            pTest.setVerbose(true);
            pTest.run();
            Test.printResult((Test)pTest);
            return;
        }
        this._vJavaSourceFiles = this._pInit.getArguments();
        if (Util.isDebug()) {
            Util.debug((Object)("_vJavaSourceFiles: " + Util.toString((Object)this._vJavaSourceFiles)));
        }
        if (htOptions.get("recursive") != null) {
            if (this._vJavaSourceFiles.size() == 0) {
                this._vJavaSourceFiles.addElement(".");
            }
            Vector newFiles = new Vector();
            Enumeration enumeration = this._vJavaSourceFiles.elements();
            while (enumeration.hasMoreElements()) {
                String fileName = FileUtil.normalizeFileName((String)((String)enumeration.nextElement()));
                File file = new File(fileName);
                if (!file.isDirectory()) continue;
                this._addJavaFiles(file, newFiles);
            }
            if (newFiles.size() != 0) {
                int i = 0;
                while (i < newFiles.size()) {
                    this._vJavaSourceFiles.add(newFiles.elementAt(i));
                    ++i;
                }
            }
            this._removeDirs(this._vJavaSourceFiles);
        }
        if (Util.isDebug()) {
            Util.debug((Object)("_vJavaSourceFiles: " + Util.toString((Object)this._vJavaSourceFiles)));
        }
        if (htOptions.get("gui") != null) {
            final JavancssFrame pJavancssFrame = new JavancssFrame(this._pInit);
            Thread pThread = Thread.currentThread();
            ((Window)((Object)pJavancssFrame)).addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e_) {
                    Util.debug((Object)"JavancssAll.run().WindowAdapter.windowClosing().1");
                    pJavancssFrame.setVisible(false);
                    ((Window)((Object)pJavancssFrame)).dispose();
                }
            });
            pJavancssFrame.setVisible(true);
            try {
                this._measureRoot(System.in);
            }
            catch (Throwable pThrowable) {
                // empty catch block
            }
            pJavancssFrame.showJavancss(this);
            pJavancssFrame.setSelectedTab("Packages");
            pJavancssFrame.run();
            return;
        }
        try {
            this._measureRoot(System.in);
        }
        catch (Throwable pThrowable) {
            // empty catch block
        }
        if (this.getLastErrorMessage() != null) {
            Util.printlnErr((String)(this.getLastErrorMessage() + "\n"));
            if (this.getNcss() <= 0) {
                return;
            }
        }
        boolean bNoNCSS = false;
        String sOutputFile = (String)htOptions.get("out");
        PrintStream ps = System.out;
        if (sOutputFile != null) {
            try {
                ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileUtil.normalizeFileName((String)sOutputFile))));
            }
            catch (Exception exception) {
                Util.printlnErr((String)("Error opening output file '" + sOutputFile + "': " + exception.getMessage()));
                ps = System.out;
                sOutputFile = null;
            }
        }
        if (this.useXML()) {
            ps.print(XmlFormatter.printStart());
        }
        if (htOptions.get("package") != null || htOptions.get("all") != null) {
            ps.print(this.printPackageNcss());
            bNoNCSS = true;
        }
        if (htOptions.get("object") != null || htOptions.get("all") != null) {
            if (bNoNCSS) {
                ps.println();
            }
            ps.print(this.printObjectNcss());
            bNoNCSS = true;
        }
        if (htOptions.get("function") != null || htOptions.get("all") != null) {
            if (bNoNCSS) {
                ps.println();
            }
            ps.print(this.printFunctionNcss());
            bNoNCSS = true;
        }
        if (!bNoNCSS) {
            ps.print(this.printJavaNcss());
        }
        if (this.useXML()) {
            if (!bNoNCSS) {
                ps.print(this.printJavaNcss());
            }
            ps.println("</javancss>");
        }
        if (sOutputFile != null) {
            ps.close();
        }
        ps = null;
    }

    public int getNcss() {
        return this._ncss;
    }

    public int getLOC() {
        return this._loc;
    }

    public int getJvdc() {
        return this._pJavaParser.getJvdc();
    }

    public int getJdcl() {
        return JavaParserTokenManager._iFormalComments;
    }

    public int getSl() {
        return JavaParserTokenManager._iSingleComments;
    }

    public int getMl() {
        return JavaParserTokenManager._iMultiComments;
    }

    public Vector getFunctionMetrics() {
        return this._vFunctionMetrics;
    }

    public Vector getObjectMetrics() {
        return this._vObjectMetrics;
    }

    public Vector getPackageMetrics() {
        return this._vPackageMetrics;
    }

    public String getLastErrorMessage() {
        if (this._sErrorMessage == null) {
            return null;
        }
        return new String(this._sErrorMessage);
    }

    public Throwable getLastError() {
        return this._thrwError;
    }

    public void setExit() {
        this._bExit = true;
    }

    public void setXML(boolean bXML) {
        this._bXML = bXML;
    }

    public boolean useXML() {
        return this._bXML || this._pInit != null && this._pInit.getOptions().get("xml") != null;
    }

    public Formatter getFormatter() {
        if (this.useXML()) {
            return new XmlFormatter(this);
        }
        return new AsciiFormatter(this);
    }
}

