/*
 * Decompiled with CFR 0.152.
 */
package javancss;

import ccl.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javancss.Javancss;
import javancss.PackageMetric;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class JavancssAntTask
extends MatchingTask {
    private CommandlineJava commandline = new CommandlineJava();
    private boolean abortOnFail = false;
    private File srcdir;
    private Path classpath;
    private File outputfile;
    private String format = "plain";
    private static final int FAILURE = 1;
    private static final int SUCCESS = 0;
    private int classPerPkgMax = Integer.MAX_VALUE;
    private int classPerPkgMin = -1;
    private int funcPerPkgMax = Integer.MAX_VALUE;
    private int funcPerPkgMin = -1;
    private int ncssPerPkgMax = Integer.MAX_VALUE;
    private int ncssPerPkgMin = -1;
    private int classPerClassMax = Integer.MAX_VALUE;
    private int classPerClassMin = -1;
    private int funcPerClassMax = Integer.MAX_VALUE;
    private int funcPerClassMin = -1;
    private int ncssPerClassMax = Integer.MAX_VALUE;
    private int ncssPerClassMin = -1;
    private int jvdcPerClassMax = Integer.MAX_VALUE;
    private int jvdcPerClassMin = -1;
    private int jvdcPerFuncMax = Integer.MAX_VALUE;
    private int jvdcPerFuncMin = -1;
    private int ccnPerFuncMax = Integer.MAX_VALUE;
    private int ccnPerFuncMin = -1;
    private int ncssPerFuncMax = Integer.MAX_VALUE;
    private int ncssPerFuncMin = -1;
    private boolean packageMetrics = true;
    private boolean classMetrics = true;
    private boolean functionMetrics = true;
    private boolean generateReport = false;
    private Javancss javancss;

    public JavancssAntTask() {
        this.commandline.setClassname("javancss.Main");
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setPackageMetrics(boolean packageMetrics) {
        this.packageMetrics = packageMetrics;
    }

    public void setClassMetrics(boolean classMetrics) {
        this.classMetrics = classMetrics;
    }

    public void setFunctionMetrics(boolean functionMetrics) {
        this.functionMetrics = functionMetrics;
    }

    public void setGenerateReport(boolean generateReport) {
        this.generateReport = generateReport;
    }

    public void setSrcdir(File srcdir) {
        this.srcdir = srcdir;
    }

    public void setOutputfile(File outputfile) {
        this.outputfile = outputfile;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public void setAbortOnFail(boolean abortOnFail) {
        this.abortOnFail = abortOnFail;
    }

    public void execute() throws BuildException {
        if (this.srcdir == null) {
            throw new BuildException("srcdir attribute must be set!");
        }
        if (!this.srcdir.exists()) {
            throw new BuildException("srcdir does not exist!");
        }
        if (!this.srcdir.isDirectory()) {
            throw new BuildException("srcdir is not a directory!");
        }
        Vector fileList = this.findFilesToAnalyse();
        if (this.thresholdsExceeded(fileList) && this.abortOnFail) {
            throw new BuildException("Metric threshold value(s) surpassed");
        }
        int exitValue = this.generateReport(fileList);
        if (exitValue == 1) {
            if (this.abortOnFail) {
                throw new BuildException("JavaNcss failed", ((Task)this).location);
            }
            this.log("JavaNcss failed", 0);
        }
    }

    private int generateReport(Vector fileList) {
        if (!this.generateReport) {
            return 0;
        }
        this.log("Generating report");
        if (this.outputfile != null) {
            this.log("Report to be stored in " + this.outputfile.getPath(), 3);
        } else {
            this.log("Report to be sent to standard output", 3);
        }
        Object[] javancssArguments = this.getCommandLineArguments(fileList);
        this.log("Executing: javancss " + Util.objectsToVector((Object[])javancssArguments), 3);
        Javancss javancss = new Javancss((String[])javancssArguments, "$Header: /home/clemens/src/java/javancss/src/javancss/RCS/JavancssAntTask.java,v 1.1 2002/06/08 19:11:31 clemens Exp clemens $");
        if (javancss.getLastError() == null) {
            return 0;
        }
        return 1;
    }

    private boolean thresholdsExceeded(Vector fileList) {
        return this.packageThresholdsExceeded(fileList) || this.classThresholdsExceeded(fileList) || this.functionThresholdsExceeded(fileList);
    }

    private Vector findFilesToAnalyse() {
        DirectoryScanner ds = super.getDirectoryScanner(this.srcdir);
        String[] files = ds.getIncludedFiles();
        if (files.length == 0) {
            this.log("No files in specified directory " + this.srcdir, 3);
        }
        return this.copyFiles(files);
    }

    private Vector copyFiles(String[] filesArray) {
        Vector<String> returnVector = new Vector<String>(filesArray.length);
        int i = 0;
        while (i < filesArray.length) {
            returnVector.addElement(this.srcdir + File.separator + filesArray[i]);
            ++i;
        }
        return returnVector;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(((ProjectComponent)this).project);
        }
        return this.classpath.createPath();
    }

    private String[] getCommandLineArguments(Vector fileList) {
        Vector<String> arguments = new Vector<String>();
        if (this.packageMetrics) {
            arguments.addElement("-package");
        }
        if (this.classMetrics) {
            arguments.addElement("-object");
        }
        if (this.functionMetrics) {
            arguments.addElement("-function");
        }
        if (this.format.equals("xml")) {
            arguments.addElement("-xml");
        }
        if (this.outputfile != null) {
            arguments.addElement("-out");
            arguments.addElement(this.outputfile.getPath());
        }
        arguments.addElement("@" + this.createSourceListFile(fileList).getPath());
        String[] javancssArguments = new String[arguments.size()];
        int argument = 0;
        while (argument < arguments.size()) {
            javancssArguments[argument] = (String)arguments.elementAt(argument);
            ++argument;
        }
        return javancssArguments;
    }

    private File createSourceListFile(Vector fileList) {
        File srcListFile;
        try {
            srcListFile = File.createTempFile("srcList", null);
            srcListFile.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(srcListFile);
            PrintWriter pw = new PrintWriter(fos);
            int i = 0;
            while (i < fileList.size()) {
                this.log(fileList.elementAt(i).toString(), 3);
                pw.println(fileList.elementAt(i).toString());
                ++i;
            }
            pw.close();
            fos.close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, ((Task)this).location);
        }
        return srcListFile;
    }

    private Javancss getJavaNcss(Vector fileList) {
        if (this.javancss == null) {
            this.log("Checking metrics on " + fileList.size() + " files");
            this.javancss = new Javancss(fileList);
        }
        return this.javancss;
    }

    private boolean packageThresholdsExceeded(Vector fileList) {
        boolean failed = false;
        if (this.classPerPkgMax != Integer.MAX_VALUE || this.classPerPkgMin != -1 || this.funcPerPkgMax != Integer.MAX_VALUE || this.funcPerPkgMin != -1 || this.ncssPerPkgMax != Integer.MAX_VALUE || this.ncssPerPkgMin != -1) {
            Vector pkgMetrics = this.getJavaNcss(fileList).getPackageMetrics();
            int i = 0;
            while (i < pkgMetrics.size()) {
                PackageMetric pkgMetric = (PackageMetric)pkgMetrics.elementAt(i);
                failed = this.packageThresholdExceeded(pkgMetric) || failed;
                ++i;
            }
        }
        return failed;
    }

    private boolean packageThresholdExceeded(PackageMetric packageMetrics) {
        boolean failed = false;
        String errorMsg = "";
        if (this.classPerPkgMax < packageMetrics.classes) {
            failed = true;
            errorMsg = packageMetrics.classes + " classes exceeds maximum per package";
        } else if (this.classPerPkgMin > packageMetrics.classes) {
            failed = true;
            errorMsg = packageMetrics.classes + " classes does not meet minimum per package";
        }
        if (this.funcPerPkgMax < packageMetrics.functions) {
            failed = true;
            errorMsg = packageMetrics.functions + " functions exceeds maximum pre package";
        } else if (this.funcPerPkgMin > packageMetrics.functions) {
            failed = true;
            errorMsg = packageMetrics.functions + " functions does not meet minimum per package";
        }
        if (this.ncssPerPkgMax < packageMetrics.ncss) {
            failed = true;
            errorMsg = packageMetrics.ncss + " NCSS exceeds maximum per package";
        } else if (this.ncssPerPkgMin > packageMetrics.ncss) {
            failed = true;
            errorMsg = packageMetrics.ncss + " NCSS does not meet minimum per package";
        }
        if (failed) {
            this.log(packageMetrics.name + " - " + errorMsg, 2);
        }
        return failed;
    }

    private boolean classThresholdsExceeded(Vector fileList) {
        boolean failed = false;
        if (this.classPerClassMax != Integer.MAX_VALUE || this.classPerClassMin != -1 || this.funcPerClassMax != Integer.MAX_VALUE || this.funcPerClassMin != -1 || this.jvdcPerClassMax != Integer.MAX_VALUE || this.jvdcPerClassMin != -1 || this.ncssPerClassMax != Integer.MAX_VALUE || this.ncssPerClassMin != -1) {
            Vector objMetrics = this.getJavaNcss(fileList).getObjectMetrics();
            int i = 0;
            while (i < objMetrics.size()) {
                Vector objMetric = (Vector)objMetrics.elementAt(i);
                failed = this.classThresholdExceeded(objMetric) || failed;
                ++i;
            }
        }
        return failed;
    }

    private boolean classThresholdExceeded(Vector classMetrics) {
        boolean failed = false;
        String errorMsg = "";
        int classPerClass = (Integer)classMetrics.elementAt(3);
        int funcPerClass = (Integer)classMetrics.elementAt(2);
        int ncssPerClass = (Integer)classMetrics.elementAt(1);
        int jvdcPerClass = (Integer)classMetrics.elementAt(6);
        if (this.classPerClassMax < classPerClass) {
            failed = true;
            errorMsg = classPerClass + " inner classes exceeds maximum per class";
        } else if (this.classPerClassMin > classPerClass) {
            failed = true;
            errorMsg = classPerClass + " inner classes does not meet minimum per class";
        }
        if (this.funcPerClassMax < funcPerClass) {
            failed = true;
            errorMsg = funcPerClass + " functions exceeds maximum pre class";
        } else if (this.funcPerClassMin > funcPerClass) {
            failed = true;
            errorMsg = funcPerClass + " functions does not meet minimum per class";
        }
        if (this.ncssPerClassMax < ncssPerClass) {
            failed = true;
            errorMsg = ncssPerClass + " NCSS exceeds maximum per class";
        } else if (this.ncssPerClassMin > ncssPerClass) {
            failed = true;
            errorMsg = ncssPerClass + " NCSS does not meet minimum per class";
        }
        if (this.jvdcPerClassMax < jvdcPerClass) {
            failed = true;
            errorMsg = jvdcPerClass + " javadoc statements exceeds maximum per class";
        } else if (this.jvdcPerClassMin > jvdcPerClass) {
            failed = true;
            errorMsg = jvdcPerClass + " javadoc statements does not meet minimum per class";
        }
        if (failed) {
            this.log(classMetrics.elementAt(0) + " - " + errorMsg, 2);
        }
        return failed;
    }

    private boolean functionThresholdsExceeded(Vector fileList) {
        boolean failed = false;
        if (this.jvdcPerFuncMax != Integer.MAX_VALUE || this.jvdcPerFuncMin != -1 || this.ccnPerFuncMax != Integer.MAX_VALUE || this.ccnPerFuncMin != -1 || this.ncssPerFuncMax != Integer.MAX_VALUE || this.ncssPerFuncMin != -1) {
            Vector funcMetrics = this.getJavaNcss(fileList).getFunctionMetrics();
            int i = 0;
            while (i < funcMetrics.size()) {
                Vector funcMetric = (Vector)funcMetrics.elementAt(i);
                failed = this.functionThresholdExceeded(funcMetric) || failed;
                ++i;
            }
        }
        return failed;
    }

    private boolean functionThresholdExceeded(Vector functionMetrics) {
        boolean failed = false;
        String errorMsg = "";
        int ccnPerFunc = (Integer)functionMetrics.elementAt(2);
        int ncssPerFunc = (Integer)functionMetrics.elementAt(1);
        int jvdcPerFunc = (Integer)functionMetrics.elementAt(3);
        if (this.ccnPerFuncMax < ccnPerFunc) {
            failed = true;
            errorMsg = ccnPerFunc + " CCN exceeds maximum per function";
        } else if (this.ccnPerFuncMin > ccnPerFunc) {
            failed = true;
            errorMsg = ccnPerFunc + " CCN does not meet minimum per function";
        }
        if (this.ncssPerFuncMax < ncssPerFunc) {
            failed = true;
            errorMsg = ncssPerFunc + " NCSS exceeds maximum per function";
        } else if (this.ncssPerFuncMin > ncssPerFunc) {
            failed = true;
            errorMsg = ncssPerFunc + " NCSS does not meet minimum per function";
        }
        if (this.jvdcPerFuncMax < jvdcPerFunc) {
            failed = true;
            errorMsg = jvdcPerFunc + " javadoc statements exceeds maximum per function";
        } else if (this.jvdcPerFuncMin > jvdcPerFunc) {
            failed = true;
            errorMsg = jvdcPerFunc + " javadoc statements does not meet minimum per function";
        }
        if (failed) {
            this.log(functionMetrics.elementAt(0) + " - " + errorMsg, 2);
        }
        return failed;
    }

    public void setClassPerPkgMax(int classPerPkgMax) {
        this.classPerPkgMax = classPerPkgMax;
    }

    public void setClassPerPkgMin(int classPerPkgMin) {
        this.classPerPkgMin = classPerPkgMin;
    }

    public void setFuncPerPkgMax(int funcPerPkgMax) {
        this.funcPerPkgMax = funcPerPkgMax;
    }

    public void setFuncPerPkgMin(int funcPerPkgMin) {
        this.funcPerPkgMin = funcPerPkgMin;
    }

    public void setNcssPerPkgMax(int ncssPerPkgMax) {
        this.ncssPerPkgMax = ncssPerPkgMax;
    }

    public void setNcssPerPkgMin(int ncssPerPkgMin) {
        this.ncssPerPkgMin = ncssPerPkgMin;
    }

    public void setClassPerClassMax(int classPerClassMax) {
        this.classPerClassMax = classPerClassMax;
    }

    public void setClassPerClassMin(int classPerClassMin) {
        this.classPerClassMin = classPerClassMin;
    }

    public void setFuncPerClassMax(int funcPerClassMax) {
        this.funcPerClassMax = funcPerClassMax;
    }

    public void setFuncPerClassMin(int funcPerClassMin) {
        this.funcPerClassMin = funcPerClassMin;
    }

    public void setNcssPerClassMax(int ncssPerClassMax) {
        this.ncssPerClassMax = ncssPerClassMax;
    }

    public void setNcssPerClassMin(int ncssPerClassMin) {
        this.ncssPerClassMin = ncssPerClassMin;
    }

    public void setJvdcPerClassMax(int jvdcPerClassMax) {
        this.jvdcPerClassMax = jvdcPerClassMax;
    }

    public void setJvdcPerClassMin(int jvdcPerClassMin) {
        this.jvdcPerClassMin = jvdcPerClassMin;
    }

    public void setCcnPerFuncMax(int ccnPerFuncMax) {
        this.ccnPerFuncMax = ccnPerFuncMax;
    }

    public void setCcnPerFuncMin(int ccnPerFuncMin) {
        this.ccnPerFuncMin = ccnPerFuncMin;
    }

    public void setNcssPerFuncMax(int ncssPerFuncMax) {
        this.ncssPerFuncMax = ncssPerFuncMax;
    }

    public void setNcssPerFuncMin(int ncssPerFuncMin) {
        this.ncssPerFuncMin = ncssPerFuncMin;
    }

    public void setJvdcPerFuncMax(int jvdcPerFuncMax) {
        this.jvdcPerFuncMax = jvdcPerFuncMax;
    }

    public void setJvdcPerFuncMin(int jvdcPerFuncMin) {
        this.jvdcPerFuncMin = jvdcPerFuncMin;
    }
}

