/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

public class Nexus {
    private static final ConcurrentMap<Nexus, Object> TYPE_INITIALIZERS = new ConcurrentHashMap<Nexus, Object>();
    private final String name;
    private final ClassLoader classLoader;
    private final int identification;

    private Nexus(Class<?> type, int identification) {
        this(Nexus.nonAnonymous(type.getName()), type.getClassLoader(), identification);
    }

    private Nexus(String name, ClassLoader classLoader, int identification) {
        this.name = name;
        this.classLoader = classLoader;
        this.identification = identification;
    }

    private static String nonAnonymous(String typeName) {
        int anonymousLoaderIndex = typeName.indexOf(47);
        return anonymousLoaderIndex == -1 ? typeName : typeName.substring(0, anonymousLoaderIndex);
    }

    public static void initialize(Class<?> type, int identification) throws Exception {
        Object typeInitializer = TYPE_INITIALIZERS.remove(new Nexus(type, identification));
        if (typeInitializer != null) {
            typeInitializer.getClass().getMethod("onLoad", Class.class).invoke(typeInitializer, type);
        }
    }

    public static void register(String name, ClassLoader classLoader, int identification, Object typeInitializer) {
        if (TYPE_INITIALIZERS.put(new Nexus(name, classLoader, identification), typeInitializer) != null) {
            Logger.getLogger("net.bytebuddy").warning("Initializer with id " + identification + " is already registered for " + name);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Nexus nexus = (Nexus)other;
        return this.identification == nexus.identification && !(this.classLoader == null ? nexus.classLoader != null : !this.classLoader.equals(nexus.classLoader)) && this.name.equals(nexus.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.identification;
        result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Nexus{name='" + this.name + '\'' + ", classLoader=" + this.classLoader + ", identification=" + this.identification + '}';
    }
}

