/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import java.util.List;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class MacedonianIdNumber
implements IdNumberGenerator {
    private static final List<String> REGIONS = List.of("41", "42", "43", "44", "45", "46", "47", "48", "49");

    @Override
    public String countryCode() {
        return "MK";
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        LocalDate birthday = Utils.birthday(faker, request);
        PersonIdNumber.Gender gender = Utils.gender(faker, request);
        String basePart = this.basePart(faker, birthday, gender);
        return new PersonIdNumber(basePart + this.checksum(basePart), birthday, gender);
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        LocalDate birthday = faker.timeAndDate().birthday();
        PersonIdNumber.Gender gender = Utils.randomGender(faker);
        String basePart = this.basePart(faker, birthday, gender);
        return basePart + (this.checksum(basePart) + 1) % 10;
    }

    private String basePart(BaseProviders faker, LocalDate bd, PersonIdNumber.Gender gender) {
        return this.dd(bd) + this.mm(bd) + this.yyy(bd) + this.rr(faker) + this.sss(faker, gender);
    }

    private String dd(LocalDate bd) {
        return "%02d".formatted(bd.getDayOfMonth());
    }

    private String mm(LocalDate bd) {
        return "%02d".formatted(bd.getMonthValue());
    }

    private String yyy(LocalDate bd) {
        return "%03d".formatted(bd.getYear() % 1000);
    }

    private String rr(BaseProviders faker) {
        return REGIONS.get(faker.number().numberBetween(0, REGIONS.size()));
    }

    private String sss(BaseProviders faker, PersonIdNumber.Gender gender) {
        int ordinal = switch (gender) {
            default -> throw new IncompatibleClassChangeError();
            case PersonIdNumber.Gender.FEMALE -> faker.number().numberBetween(500, 1000);
            case PersonIdNumber.Gender.MALE -> faker.number().numberBetween(0, 500);
        };
        return "%03d".formatted(ordinal);
    }

    int checksum(String text) {
        int a = Utils.digitAt(text, 0);
        int b = Utils.digitAt(text, 1);
        int c = Utils.digitAt(text, 2);
        int d = Utils.digitAt(text, 3);
        int e = Utils.digitAt(text, 4);
        int f = Utils.digitAt(text, 5);
        int g = Utils.digitAt(text, 6);
        int h = Utils.digitAt(text, 7);
        int i = Utils.digitAt(text, 8);
        int j = Utils.digitAt(text, 9);
        int k = Utils.digitAt(text, 10);
        int l = Utils.digitAt(text, 11);
        int m = 11 - (7 * (a + g) + 6 * (b + h) + 5 * (c + i) + 4 * (d + j) + 3 * (e + k) + 2 * (f + l)) % 11;
        return switch (m) {
            case 10, 11 -> 0;
            default -> m;
        };
    }
}

