/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class UkrainianIdNumber
implements IdNumberGenerator {
    private static final int[] CHECKSUM_WEIGHTS = new int[]{7, 3, 1, 7, 3, 1, 7, 3, 1, 7, 3, 1};

    @Override
    public String countryCode() {
        return "UA";
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        LocalDate birthday = faker.timeAndDate().birthday();
        String dob = DateTimeFormatter.ofPattern("yyyyMMdd").format(birthday);
        String numbers = faker.numerify("####");
        int multiplied = Utils.multiply(dob + numbers, CHECKSUM_WEIGHTS);
        int checksum = (multiplied + 1) % 10;
        return dob + "-" + numbers + checksum;
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        LocalDate birthday = faker.timeAndDate().birthday();
        String dob = DateTimeFormatter.ofPattern("yyyyMMdd").format(birthday);
        String numbers = faker.numerify("####");
        int checksum = Utils.multiply(dob + numbers, CHECKSUM_WEIGHTS) % 10;
        String unzr = dob + "-" + numbers + checksum;
        return new PersonIdNumber(unzr, birthday, Utils.gender(faker, request));
    }
}

