/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import net.datafaker.providers.base.ProviderRegistration;

public class AbstractProvider<T extends ProviderRegistration> {
    protected final T faker;

    protected AbstractProvider(T faker) {
        this.faker = faker;
    }

    public final ProviderRegistration getFaker() {
        return this.faker;
    }

    protected String resolve(String key) {
        return this.faker.fakeValuesService().resolve(key, this, this.faker.getContext());
    }

    protected String resolve(String key, Supplier<String> message) {
        return this.faker.fakeValuesService().resolve(key, this, (ProviderRegistration)this.faker, message, this.faker.getContext());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractProvider)) {
            return false;
        }
        AbstractProvider that = (AbstractProvider)o;
        return Objects.equals(this.faker, that.faker);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    protected final <G> List<G> loadGenerators(Class<G> generatorClass) {
        return ServiceLoader.load(generatorClass).stream().map(ServiceLoader.Provider::get).toList();
    }

    public String toString() {
        return "%s(%s)@%s".formatted(this.getClass().getSimpleName(), this.faker, Integer.toHexString(this.hashCode()));
    }
}

