/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.TreeSet;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Commerce
extends AbstractProvider<BaseProviders> {
    private final DecimalFormatSymbols decimalFormatSymbols;

    protected Commerce(BaseProviders faker) {
        super(faker);
        this.decimalFormatSymbols = new DecimalFormatSymbols(faker.getContext().getLocale());
    }

    public String department() {
        int numberOfDepartments = Math.max(((BaseProviders)this.faker).random().nextInt(4), 1);
        TreeSet<String> departments = new TreeSet<String>();
        while (departments.size() < numberOfDepartments) {
            departments.add(((BaseProviders)this.faker).resolve("commerce.department"));
        }
        if (departments.size() > 1) {
            String lastDepartment = (String)departments.last();
            return String.join((CharSequence)", ", departments.headSet(lastDepartment)) + " & " + lastDepartment;
        }
        return (String)departments.first();
    }

    public String productName() {
        return String.join((CharSequence)" ", this.resolve("commerce.product_name.adjective"), this.resolve("commerce.product_name.material"), this.resolve("commerce.product_name.product"));
    }

    public String material() {
        return this.resolve("commerce.product_name.material");
    }

    public String brand() {
        return this.resolve("commerce.brand");
    }

    public String vendor() {
        return this.resolve("commerce.vendor");
    }

    public String price() {
        return this.price(0.0, 100.0);
    }

    public String price(double min, double max) {
        double price = min + ((BaseProviders)this.faker).random().nextDouble() * (max - min);
        return new DecimalFormat("#0.00", this.decimalFormatSymbols).format(price);
    }

    public String promotionCode() {
        return this.promotionCode(6);
    }

    public String promotionCode(int digits) {
        return String.join((CharSequence)((BaseProviders)this.faker).resolve("commerce.promotion_code.adjective"), this.resolve("commerce.promotion_code.noun"), ((BaseProviders)this.faker).number().digits(digits));
    }
}

