/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.datafaker.idnumbers.AmericanIdNumber;
import net.datafaker.idnumbers.ChineseIdNumber;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.MexicanIdNumber;
import net.datafaker.idnumbers.PolishIdNumber;
import net.datafaker.idnumbers.PortugueseIdNumber;
import net.datafaker.idnumbers.SingaporeIdNumber;
import net.datafaker.idnumbers.SouthAfricanIdNumber;
import net.datafaker.idnumbers.SouthKoreanIdNumber;
import net.datafaker.idnumbers.SwedenIdNumber;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.PersonIdNumber;

public class IdNumber
extends AbstractProvider<BaseProviders> {
    private final Map<Class<? extends IdNumberGenerator>, IdNumberGenerator> providers = new ConcurrentHashMap<Class<? extends IdNumberGenerator>, IdNumberGenerator>();
    private final Map<String, IdNumberGenerator> countryProviders = new ConcurrentHashMap<String, IdNumberGenerator>();

    protected IdNumber(BaseProviders faker) {
        super(faker);
        List<IdNumberGenerator> idNumbers = this.loadGenerators(IdNumberGenerator.class);
        for (IdNumberGenerator idNumber : idNumbers) {
            this.countryProviders.put(idNumber.countryCode(), idNumber);
        }
    }

    public String valid() {
        return this.countryProvider().map(p -> p.generateValid((BaseProviders)this.faker)).orElseGet(() -> ((BaseProviders)this.faker).numerify(((BaseProviders)this.faker).resolve("id_number.valid")));
    }

    public String invalid() {
        return this.countryProvider().map(p -> p.generateInvalid((BaseProviders)this.faker)).orElseGet(() -> ((BaseProviders)this.faker).numerify(((BaseProviders)this.faker).resolve("id_number.invalid")));
    }

    public PersonIdNumber valid(IdNumberRequest request) {
        return this.countryProvider().map(p -> p.generateValid((BaseProviders)this.faker, request)).orElseThrow(() -> new IllegalArgumentException("ID Number generation not supported for country '%s'".formatted(this.country())));
    }

    private Optional<IdNumberGenerator> countryProvider() {
        return Optional.ofNullable(this.countryProviders.get(this.country()));
    }

    private String country() {
        return ((BaseProviders)this.faker).getContext().getLocale().getCountry();
    }

    public String ssnValid() {
        return this.provider(AmericanIdNumber.class).generateValid((BaseProviders)this.faker);
    }

    @Deprecated
    public String validSvSeSsn() {
        return this.provider(SwedenIdNumber.class).generateValid((BaseProviders)this.faker);
    }

    @Deprecated
    public String invalidSvSeSsn() {
        return this.provider(SwedenIdNumber.class).generateInvalid((BaseProviders)this.faker);
    }

    @Deprecated
    public String validEnZaSsn() {
        return this.provider(SouthAfricanIdNumber.class).getValidSsn((BaseProviders)this.faker);
    }

    @Deprecated
    public String inValidEnZaSsn() {
        return this.provider(SouthAfricanIdNumber.class).getInValidSsn((BaseProviders)this.faker);
    }

    public String singaporeanFin() {
        return SingaporeIdNumber.getValidFIN((BaseProviders)this.faker, SingaporeIdNumber.Type.FOREIGNER_TWENTY_FIRST_CENTURY);
    }

    public String singaporeanFinBefore2000() {
        return SingaporeIdNumber.getValidFIN((BaseProviders)this.faker, SingaporeIdNumber.Type.FOREIGNER_TWENTIETH_CENTURY);
    }

    public String singaporeanUin() {
        return SingaporeIdNumber.getValidFIN((BaseProviders)this.faker, SingaporeIdNumber.Type.SINGAPOREAN_TWENTY_FIRST_CENTURY);
    }

    public String singaporeanUinBefore2000() {
        return SingaporeIdNumber.getValidFIN((BaseProviders)this.faker, SingaporeIdNumber.Type.SINGAPOREAN_TWENTIETH_CENTURY);
    }

    @Deprecated
    public String validZhCNSsn() {
        return this.provider(ChineseIdNumber.class).generateValid((BaseProviders)this.faker);
    }

    @Deprecated
    public String validPtNif() {
        return this.provider(PortugueseIdNumber.class).generateValid((BaseProviders)this.faker);
    }

    @Deprecated
    public String invalidPtNif() {
        return this.provider(PortugueseIdNumber.class).generateInvalid((BaseProviders)this.faker);
    }

    @Deprecated
    public String validEsMXSsn() {
        return this.provider(MexicanIdNumber.class).get((BaseProviders)this.faker);
    }

    @Deprecated
    public String invalidEsMXSsn() {
        return this.provider(MexicanIdNumber.class).generateInvalid((BaseProviders)this.faker);
    }

    @Deprecated
    public String peselNumber() {
        return this.peselNumber(((BaseProviders)this.faker).timeAndDate().birthday(0, 100), PolishIdNumber.Gender.ANY);
    }

    @Deprecated
    public String peselNumber(LocalDate birthDate, PolishIdNumber.Gender gender) {
        return new PolishIdNumber().get((BaseProviders)this.faker, birthDate, gender);
    }

    @Deprecated
    public String validKoKrRrn() {
        return this.provider(SouthKoreanIdNumber.class).getValidRrn((BaseProviders)this.faker);
    }

    @Deprecated
    public String validGeIDNumber() {
        return ((BaseProviders)this.faker).numerify("###########");
    }

    private <T extends IdNumberGenerator> T provider(Class<T> clazz) {
        return (T)this.providers.computeIfAbsent(clazz, aClass -> this.create(clazz));
    }

    private <T extends IdNumberGenerator> T create(Class<T> clazz) {
        try {
            return (T)((IdNumberGenerator)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate class " + clazz.getName(), e);
        }
    }

    public record IdNumberRequest(int minAge, int maxAge, GenderRequest gender) {
    }

    public static enum GenderRequest {
        FEMALE,
        MALE,
        ANY;

    }
}

