/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.lang.invoke.LambdaMetafactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.datafaker.internal.helper.FakerIDN;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.service.RandomService;

public class Internet
extends AbstractProvider<BaseProviders> {
    private static final Pattern COLON = Pattern.compile(":");
    private static final List<String> HTTP_SCHEMES = List.of("http://", "https://");
    private static final int MIN_PORT_NUMBER = 0;
    private static final int MAX_PORT_NUMBER = 65535;
    public static final Pattern DIACRITICS_AND_FRIENDS = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");
    private static final Pattern LOCALPART = Pattern.compile("[^a-z0-9\\.]");

    protected Internet(BaseProviders faker) {
        super(faker);
    }

    @Deprecated(since="2.5.0", forRemoval=true)
    public String username() {
        return ((BaseProviders)this.faker).credentials().username();
    }

    public String emailAddress() {
        return this.emailAddress(((BaseProviders)this.faker).credentials().username());
    }

    public String emailAddress(String name) {
        return this.emailAddress(this.toLocalPart(name), FakerIDN.toASCII(((BaseProviders)this.faker).resolve("internet.free_email")));
    }

    public String safeEmailAddress() {
        return this.safeEmailAddress(((BaseProviders)this.faker).credentials().username());
    }

    public String safeEmailAddress(String name) {
        return this.emailAddress(this.toLocalPart(name), FakerIDN.toASCII(((BaseProviders)this.faker).resolve("internet.safe_email")));
    }

    private String emailAddress(String localPart, String domain) {
        return String.join((CharSequence)"", this.stripAccents(localPart), "@", domain);
    }

    public String emailSubject() {
        return this.resolve("internet.email_subject");
    }

    private String stripAccents(String input) {
        String str = Normalizer.normalize(input, Normalizer.Form.NFD);
        str = DIACRITICS_AND_FRIENDS.matcher(str).replaceAll("");
        return str;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private String toLocalPart(String name) {
        parts = this.stripAccents(name).split(" ");
        prefixObj = ((BaseProviders)this.faker).fakeValuesService().fetchObject("name.prefix", ((BaseProviders)this.faker).getContext());
        if (!(prefixObj instanceof List)) ** GOTO lbl-1000
        list = (List)prefixObj;
        if (list.stream().allMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(String.class))) {
            v0 /* !! */  = list.stream().map((Function<Object, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)(String.class)).toList();
        } else lbl-1000:
        // 2 sources

        {
            v0 /* !! */  = prefixList = Collections.emptyList();
        }
        if (prefixList.contains(parts[0])) {
            parts = Arrays.copyOfRange(parts, 1, parts.length);
        }
        if (!((suffixObj = ((BaseProviders)this.faker).fakeValuesService().fetchObject("name.suffix", ((BaseProviders)this.faker).getContext())) instanceof List)) ** GOTO lbl-1000
        list = (List)suffixObj;
        if (list.stream().allMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(String.class))) {
            v1 /* !! */  = list.stream().map((Function<Object, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)(String.class)).toList();
        } else lbl-1000:
        // 2 sources

        {
            v1 /* !! */  = suffixList = Collections.emptyList();
        }
        if (suffixList.contains(parts[parts.length - 1])) {
            parts = Arrays.copyOfRange(parts, 0, parts.length - 1);
        }
        if (parts.length == 0) {
            return Internet.LOCALPART.matcher(name.toLowerCase(((BaseProviders)this.faker).getContext().getLocale())).replaceAll("");
        }
        if (parts.length == 1) {
            return Internet.LOCALPART.matcher(parts[0].toLowerCase(((BaseProviders)this.faker).getContext().getLocale())).replaceAll("");
        }
        return String.join((CharSequence)".", new CharSequence[]{Internet.LOCALPART.matcher(parts[0].toLowerCase(((BaseProviders)this.faker).getContext().getLocale())).replaceAll(""), Internet.LOCALPART.matcher(parts[parts.length - 1].toLowerCase(((BaseProviders)this.faker).getContext().getLocale())).replaceAll("")});
    }

    public String domainName() {
        return this.domainWord() + "." + this.domainSuffix();
    }

    public String domainWord() {
        return FakerIDN.toASCII(((BaseProviders)this.faker).name().lastName().toLowerCase(((BaseProviders)this.faker).getContext().getLocale()).replace("'", ""));
    }

    public String domainSuffix() {
        return this.resolve("internet.domain_suffix");
    }

    public String url() {
        byte[] bts = ((BaseProviders)this.faker).random().nextRandomBytes(6);
        return this.url(bts[0] % 2 == 0, bts[1] % 2 == 0, bts[2] % 2 == 0, bts[3] % 2 == 0, bts[4] % 2 == 0, bts[5] % 2 == 0);
    }

    public String url(boolean schemeChoice, boolean portChoice, boolean pathChoice, boolean fileChoice, boolean paramsChoice, boolean anchorChoice) {
        String scheme = schemeChoice ? ((BaseProviders)this.faker).options().nextElement(HTTP_SCHEMES) : "https://";
        String port = portChoice ? ":" + this.port() : "";
        String path = pathChoice ? "/" + this.slug(((BaseProviders)this.faker).lorem().words(2), "/") : "/";
        String file = fileChoice ? ((BaseProviders)this.faker).lorem().words(1).get(0) : "";
        String params = paramsChoice ? "?" + this.slug(((BaseProviders)this.faker).lorem().words(2), "=") + "&" + this.slug(((BaseProviders)this.faker).lorem().words(2), "=") : "";
        String anchor = anchorChoice ? "#" + ((BaseProviders)this.faker).lorem().words(1).get(0) : "";
        return scheme + this.webdomain() + port + path + file + params + anchor;
    }

    public String webdomain() {
        return String.join((CharSequence)"", "www", ".", FakerIDN.toASCII(((BaseProviders)this.faker).name().firstName().toLowerCase(((BaseProviders)this.faker).getContext().getLocale()).replace("'", "") + "-" + this.domainWord()), ".", this.domainSuffix());
    }

    public String image() {
        String[] dimension = this.resolve("internet.image_dimension").split("x");
        if (dimension.length == 0) {
            return "";
        }
        return this.image(Integer.parseInt(dimension[0].trim()), Integer.parseInt(dimension[1].trim()));
    }

    public String image(int width, int height) {
        return "https://picsum.photos/%s/%s".formatted(width, height);
    }

    public String image(int width, int height, String seed) {
        return "https://picsum.photos/seed/%s/%s/%s".formatted(seed, width, height);
    }

    public String httpMethod() {
        return this.resolve("internet.http_method");
    }

    @Deprecated(since="2.5.0", forRemoval=true)
    public String password() {
        return this.password(8, 16);
    }

    @Deprecated(since="2.5.0", forRemoval=true)
    public String password(boolean includeDigit) {
        return this.password(8, 16, false, false, includeDigit);
    }

    @Deprecated(since="2.5.0", forRemoval=true)
    public String password(int minimumLength, int maximumLength) {
        return this.password(minimumLength, maximumLength, false);
    }

    @Deprecated(since="2.5.0", forRemoval=true)
    public String password(int minimumLength, int maximumLength, boolean includeUppercase) {
        return this.password(minimumLength, maximumLength, includeUppercase, false);
    }

    @Deprecated(since="2.5.0", forRemoval=true)
    public String password(int minimumLength, int maximumLength, boolean includeUppercase, boolean includeSpecial) {
        return this.password(minimumLength, maximumLength, includeUppercase, includeSpecial, true);
    }

    @Deprecated(since="2.5.0", forRemoval=true)
    public String password(int minimumLength, int maximumLength, boolean includeUppercase, boolean includeSpecial, boolean includeDigit) {
        return ((BaseProviders)this.faker).text().text(minimumLength, maximumLength, includeUppercase, includeSpecial, includeDigit);
    }

    public int port() {
        return this.port(0, 65535);
    }

    public int port(PortRange range) {
        return this.port(range.from, range.to);
    }

    public int port(int from, int to) {
        if (from < 0) {
            throw new IllegalArgumentException("Port number %s cannot be less than %s".formatted(from, 0));
        }
        if (to > 65535) {
            throw new IllegalArgumentException("Port number %s cannot be greater than %s".formatted(to, 65535));
        }
        return ((BaseProviders)this.faker).random().nextInt(from, to);
    }

    public String macAddress(String prefix) {
        String tmp = prefix == null ? "" : prefix;
        int prefixLength = tmp.trim().isEmpty() ? 0 : COLON.split(tmp).length;
        StringBuilder out = new StringBuilder(tmp);
        for (int i = 0; i < 6 - prefixLength; ++i) {
            if (!out.isEmpty()) {
                out.append(':');
            }
            out.append(Integer.toHexString(((BaseProviders)this.faker).random().nextInt(16)));
            out.append(Integer.toHexString(((BaseProviders)this.faker).random().nextInt(16)));
        }
        return out.toString();
    }

    public String macAddress() {
        return this.macAddress("");
    }

    public String ipV4Address() {
        return this.getIpV4Address().getHostAddress();
    }

    public InetAddress getIpV4Address() {
        return Internet.inet4Address((byte)(((BaseProviders)this.faker).random().nextInt(254) + 2), (byte)(((BaseProviders)this.faker).random().nextInt(254) + 2), (byte)(((BaseProviders)this.faker).random().nextInt(254) + 2), (byte)(((BaseProviders)this.faker).random().nextInt(254) + 2));
    }

    public String privateIpV4Address() {
        return this.getPrivateIpV4Address().getHostAddress();
    }

    public InetAddress getPrivateIpV4Address() {
        Byte[] PRIVATE_FIRST_OCTET = new Byte[]{(byte)10, (byte)127, (byte)-87, (byte)-64, (byte)-84};
        Byte[] PRIVATE_SECOND_OCTET_172 = new Byte[]{(byte)16, (byte)17, (byte)18, (byte)19, (byte)20, (byte)21, (byte)22, (byte)23, (byte)24, (byte)25, (byte)26, (byte)27, (byte)28, (byte)29, (byte)30, (byte)31};
        RandomService r = ((BaseProviders)this.faker).random();
        byte first = this.random(PRIVATE_FIRST_OCTET);
        byte second = (byte)r.nextInt(256);
        byte third = (byte)r.nextInt(256);
        byte fourth = (byte)r.nextInt(256);
        switch (first) {
            case -84: {
                second = this.random(PRIVATE_SECOND_OCTET_172);
                break;
            }
            case -64: {
                second = -88;
                break;
            }
            case -87: {
                second = -2;
            }
        }
        return Internet.inet4Address(first, second, third, fourth);
    }

    public String publicIpV4Address() {
        return this.getPublicIpV4Address().getHostAddress();
    }

    public InetAddress getPublicIpV4Address() {
        RandomService r = ((BaseProviders)this.faker).random();
        byte[] PRIVATE_FIRST_OCTET = new byte[]{10, 127, -87, -64, -84};
        byte first = (byte)r.nextInt(256);
        byte second = (byte)r.nextInt(256);
        byte third = (byte)r.nextInt(256);
        byte fourth = (byte)r.nextInt(256);
        while (Arrays.binarySearch(PRIVATE_FIRST_OCTET, first) > 0) {
            first = (byte)r.nextInt(256);
        }
        return Internet.inet4Address(first, second, third, fourth);
    }

    public String ipV4Cidr() {
        return this.ipV4Address() + "/" + (((BaseProviders)this.faker).random().nextInt(31) + 1);
    }

    public String ipV6Address() {
        return this.getIpV6Address().getHostAddress();
    }

    public InetAddress getIpV6Address() {
        RandomService random = ((BaseProviders)this.faker).random();
        char[] res = new char[39];
        for (int i = 0; i < 8; ++i) {
            int offset = 4 * i;
            if (i > 0) {
                res[i - 1 + offset] = 58;
            }
            char[] hex = random.hex(4, false).toCharArray();
            System.arraycopy(hex, 0, res, i + offset, hex.length);
        }
        return Internet.inet6Address(String.valueOf(res));
    }

    public String ipV6Cidr() {
        return this.ipV6Address() + "/" + (((BaseProviders)this.faker).random().nextInt(127) + 1);
    }

    public String slug() {
        return this.slug(((BaseProviders)this.faker).lorem().words(2), "_");
    }

    public String slug(List<String> wordsOrNull, String glueOrNull) {
        String glue = glueOrNull == null ? "_" : glueOrNull;
        List<String> words = wordsOrNull == null ? ((BaseProviders)this.faker).lorem().words(2) : wordsOrNull;
        StringBuilder slug = new StringBuilder();
        for (int i = 0; i < words.size(); ++i) {
            if (i > 0) {
                slug.append(glue);
            }
            slug.append(words.get(i));
        }
        return slug.toString();
    }

    public String uuidv3() {
        return UUID.nameUUIDFromBytes(((BaseProviders)this.faker).random().nextRandomBytes(16)).toString();
    }

    public String uuidv4() {
        return this.uuid();
    }

    public String uuidv7() {
        long timestamp = ((BaseProviders)this.faker).random().nextLong();
        long randomBits1 = ((BaseProviders)this.faker).random().nextLong();
        long randomBits2 = ((BaseProviders)this.faker).random().nextLong();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(timestamp);
        bb.putLong(randomBits1 ^ randomBits2);
        long mostSigBits = bb.getLong(0);
        long leastSigBits = bb.getLong(8);
        mostSigBits &= 0xFFFFFFFFFFFF0FFFL;
        leastSigBits &= 0x3FFFFFFFFFFFFFFFL;
        return new UUID(mostSigBits |= 0x7000L, leastSigBits |= Long.MIN_VALUE).toString();
    }

    public String uuid() {
        String uuidv3 = this.uuidv3();
        return uuidv3.substring(0, 14) + "4" + uuidv3.substring(15);
    }

    private <T> T random(T[] src) {
        return src[((BaseProviders)this.faker).random().nextInt(src.length)];
    }

    public String userAgent(UserAgent userAgent) {
        UserAgent agent = userAgent;
        if (agent == null) {
            agent = UserAgent.any((BaseProviders)this.faker);
        }
        String userAgentKey = "internet.user_agent." + agent.toString();
        return this.resolve(userAgentKey);
    }

    public String userAgent() {
        return this.userAgent(null);
    }

    public String botUserAgent(BotUserAgent vendor) {
        BotUserAgent agent = vendor;
        if (agent == null) {
            agent = BotUserAgent.any((BaseProviders)this.faker);
        }
        String userAgentKey = "internet.bot_user_agent." + agent.toString();
        return this.resolve(userAgentKey);
    }

    public String botUserAgentAny() {
        return this.botUserAgent(null);
    }

    private static InetAddress inet4Address(byte first, byte second, byte third, byte fourth) {
        try {
            return Inet4Address.getByAddress(new byte[]{first, second, third, fourth});
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to create Inet4Address from %s %s %s %s".formatted(first, second, third, fourth), e);
        }
    }

    private static InetAddress inet6Address(String host) {
        try {
            return Inet6Address.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to create Inet6Address from host '%s'".formatted(host), e);
        }
    }

    public static enum PortRange {
        WellKnownPorts(0, 1023),
        RegisteredPorts(1024, 49151),
        DynamicPrivatePorts(49152, 65535);

        private final int from;
        private final int to;

        private PortRange(int from, int to) {
            this.from = from;
            this.to = to;
        }
    }

    public static enum UserAgent {
        AOL("aol"),
        CHROME("chrome"),
        FIREFOX("firefox"),
        INTERNET_EXPLORER("internet_explorer"),
        NETSCAPE("netscape"),
        OPERA("opera"),
        SAFARI("safari");

        private final String browserName;

        private UserAgent(String browserName) {
            this.browserName = browserName;
        }

        private static UserAgent any(BaseProviders faker) {
            UserAgent[] agents = UserAgent.values();
            int randomIndex = (int)(faker.random().nextDouble() * (double)agents.length);
            return agents[randomIndex];
        }

        public String toString() {
            return this.browserName;
        }
    }

    public static enum BotUserAgent {
        GOOGLEBOT("googlebot"),
        BINGBOT("bingbot"),
        DUCKDUCKBOT("duckduckbot"),
        BAIDUSPIDER("baiduspider"),
        YANDEXBOT("yandexbot");

        private final String browserName;

        private BotUserAgent(String browserName) {
            this.browserName = browserName;
        }

        private static BotUserAgent any(BaseProviders faker) {
            BotUserAgent[] agents = BotUserAgent.values();
            int randomIndex = (int)(faker.random().nextDouble() * (double)agents.length);
            return agents[randomIndex];
        }

        public String toString() {
            return this.browserName;
        }
    }
}

