/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.random.RandomGenerator;
import net.datafaker.annotations.Deterministic;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Locality
extends AbstractProvider<BaseProviders> {
    private static final List<String> LOCALES = List.of("_al", "_ar", "_au", "_at", "_bg", "_by", "_ca", "_ch", "_cn", "_cz", "_dk", "_ee", "_fi", "_fr", "_gb", "_ge", "_hu", "_jp", "_il", "_in", "_kr", "_lv", "_no", "_md", "_mk", "_nl", "_pl", "_py", "_ru", "_se", "_tr", "_tw", "_ua", "_us", "_uz", "_vn", "_es", "_sk", "_id", "_hr", "_pt", "_ie", "_it", "_de", "_am", "_mx", "_br", "_be", "_th", "ar", "be", "bg", "by", "ca", "ca-cat", "cs", "cs-cz", "da-dk", "de", "de-at", "de-ch", "el-gr", "en", "en-au", "en-au-ocker", "en-bork", "en-ca", "en-gb", "en-ie", "en-in", "en-md", "en-ms", "en-nep", "en-ng", "en-nz", "en-pak", "en-ph", "en-pk", "en-sg", "en-ug", "en-us", "en-za", "es", "es-ar", "es-mx", "es-py", "et", "fa", "fi-fi", "fr", "fr-ca", "fr-ch", "he", "hr", "hu", "hy", "id", "id-id", "it", "ja", "ka", "ko", "lv", "mk", "nb-no", "nl", "nl-be", "no-no", "pl", "pt", "pt-br", "ro-md", "ru", "ru-md", "sk", "sq", "sv", "sv-se", "ta", "ta-in", "th", "tr", "uk", "uz", "vi", "zh-cn", "zh-tw");
    private final List<String> shuffledLocales = new ArrayList<String>();
    private int shuffledLocaleIndex = 0;

    public Locality(BaseProviders baseProviders) {
        super(baseProviders);
    }

    @Deprecated
    public List<String> allSupportedLocales(Set<String> fileMasks) {
        return this.allSupportedLocales();
    }

    @Deterministic
    public final List<String> allSupportedLocales() {
        return LOCALES;
    }

    public String displayName() {
        int randomIndex = ((BaseProviders)this.faker).random().nextInt(LOCALES.size());
        Locale locale = Locale.forLanguageTag(LOCALES.get(randomIndex));
        Object displayLanguage = locale.getDisplayLanguage(Locale.ROOT);
        String displayCountry = locale.getDisplayCountry(Locale.ROOT);
        if (!displayCountry.isEmpty()) {
            displayLanguage = (String)displayLanguage + " (" + displayCountry + ")";
        }
        return ((String)displayLanguage).isEmpty() ? Locale.ENGLISH.getDisplayLanguage(Locale.ROOT) : displayLanguage;
    }

    public String localeString() {
        return this.localeStringWithRandom(((BaseProviders)this.faker).random().getRandomInternal());
    }

    public String localeStringWithRandom(RandomGenerator random) {
        int randomIndex = random.nextInt(LOCALES.size());
        return LOCALES.get(randomIndex);
    }

    public String localeStringWithoutReplacement() {
        return this.localeStringWithoutReplacement(((BaseProviders)this.faker).random().getRandomInternal());
    }

    public synchronized String localeStringWithoutReplacement(RandomGenerator random) {
        if (this.shuffledLocales.isEmpty() || this.shuffledLocaleIndex >= this.shuffledLocales.size() - 1) {
            this.shuffledLocales.clear();
            this.shuffledLocales.addAll(LOCALES);
            this.shuffledLocaleIndex = 0;
            Locality.shuffle(this.shuffledLocales, random);
        }
        return this.shuffledLocales.get(this.shuffledLocaleIndex++);
    }

    private static void shuffle(List<String> list, RandomGenerator rnd) {
        for (int i = list.size(); i > 1; --i) {
            list.set(i - 1, list.set(rnd.nextInt(i), list.get(i - 1)));
        }
    }
}

