/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.nio.charset.StandardCharsets;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Sip
extends AbstractProvider<BaseProviders> {
    private final int[] portPool = new int[5001];

    public Sip(BaseProviders faker) {
        super(faker);
        for (int i = 0; i < this.portPool.length; ++i) {
            this.portPool[i] = 40000 + 2 * i;
        }
    }

    public String method() {
        return this.resolve("sip.methods");
    }

    public String contentType() {
        return this.resolve("sip.content.types");
    }

    public int messagingPort() {
        return ((BaseProviders)this.faker).random().nextInt(1000, 9999);
    }

    public int rtpPort() {
        return ((BaseProviders)this.faker).options().option(this.portPool);
    }

    public int provisionalResponseCode() {
        return Integer.parseInt(((BaseProviders)this.faker).resolve("sip.response.codes.provisional"));
    }

    public int successResponseCode() {
        return Integer.parseInt(((BaseProviders)this.faker).resolve("sip.response.codes.success"));
    }

    public int redirectResponseCode() {
        return Integer.parseInt(((BaseProviders)this.faker).resolve("sip.response.codes.redirection"));
    }

    public int clientErrorResponseCode() {
        return Integer.parseInt(((BaseProviders)this.faker).resolve("sip.response.codes.clientError"));
    }

    public int serverErrorResponseCode() {
        return Integer.parseInt(((BaseProviders)this.faker).resolve("sip.response.codes.serverError"));
    }

    public int globalErrorResponseCode() {
        return Integer.parseInt(((BaseProviders)this.faker).resolve("sip.response.codes.globalError"));
    }

    public String provisionalResponsePhrase() {
        return this.resolve("sip.response.phrases.provisional");
    }

    public String successResponsePhrase() {
        return this.resolve("sip.response.phrases.success");
    }

    public String redirectResponsePhrase() {
        return this.resolve("sip.response.phrases.redirection");
    }

    public String clientErrorResponsePhrase() {
        return this.resolve("sip.response.phrases.clientError");
    }

    public String serverErrorResponsePhrase() {
        return this.resolve("sip.response.phrases.serverError");
    }

    public String globalErrorResponsePhrase() {
        return this.resolve("sip.response.phrases.globalError");
    }

    public String bodyString() {
        return "v=0\no=" + ((BaseProviders)this.faker).name().firstName() + " " + ((BaseProviders)this.faker).internet().uuid() + " IN IP4 " + ((BaseProviders)this.faker).internet().domainName() + "\ns=-\nc=IN IP4 " + ((BaseProviders)this.faker).internet().ipV4Address() + "\nt=0 0\nm=audio " + this.rtpPort() + " RTP/AVP 0\na=rtpmap:0 PCMU/8000";
    }

    public byte[] bodyBytes() {
        return this.bodyString().getBytes(StandardCharsets.UTF_8);
    }

    public String nameAddress() {
        return "<sip:" + ((BaseProviders)this.faker).name().firstName() + "@" + ((BaseProviders)this.faker).internet().ipV4Address() + ":" + this.messagingPort() + ">";
    }
}

