/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Text
extends AbstractProvider<BaseProviders> {
    private final Map<TextConfigPojo, TextRuleConfig> configMap = new WeakHashMap<TextConfigPojo, TextRuleConfig>();
    public static final String EN_LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String EN_UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String DIGITS = "0123456789";
    public static final String DEFAULT_SPECIAL = "!@#$%^&*";

    public Character character() {
        return Character.valueOf(this.text(1, 1, true).charAt(0));
    }

    public Character uppercaseCharacter() {
        return Character.valueOf(this.text(1, 1).toUpperCase(((BaseProviders)this.faker).getContext().getLocale()).charAt(0));
    }

    public Character lowercaseCharacter() {
        return Character.valueOf(this.text(1, 1, false).charAt(0));
    }

    public String text() {
        return this.text(false);
    }

    public String text(boolean includeDigit) {
        return this.text(20, 80, false, false, includeDigit);
    }

    public String text(int length) {
        return this.text(length, length, false);
    }

    public String text(int minimumLength, int maximumLength) {
        return this.text(minimumLength, maximumLength, false);
    }

    public String text(int minimumLength, int maximumLength, boolean includeUppercase) {
        return this.text(minimumLength, maximumLength, includeUppercase, false);
    }

    public String text(int minimumLength, int maximumLength, boolean includeUppercase, boolean includeSpecial) {
        return this.text(minimumLength, maximumLength, includeUppercase, includeSpecial, false);
    }

    public String text(int minimumLength, int maximumLength, boolean includeUppercase, boolean includeSpecial, boolean includeDigit) {
        if (minimumLength > maximumLength) {
            throw new IllegalArgumentException("Min length (%s) should not be greater than max length (%s)".formatted(minimumLength, maximumLength));
        }
        int minLength = Math.max(minimumLength, Text.min(includeUppercase) + Text.min(includeSpecial) + Text.min(includeDigit));
        if (minLength > maximumLength) {
            throw new IllegalArgumentException("Minimum number of required characters (%s) should not be greater than max length (%s)".formatted(minLength, maximumLength));
        }
        int len = ((BaseProviders)this.faker).number().numberBetween(minLength, maximumLength + 1);
        TextConfigPojo pojo = new TextConfigPojo(len, includeUppercase, includeSpecial, includeDigit);
        TextRuleConfig config = this.configMap.computeIfAbsent(pojo, x -> {
            TextSymbolsBuilder builder = TextSymbolsBuilder.builder().with(EN_LOWERCASE);
            if (includeUppercase) {
                builder = builder.with(EN_UPPERCASE, 1);
            }
            if (includeSpecial) {
                builder = builder.with(DEFAULT_SPECIAL, 1);
            }
            if (includeDigit) {
                builder = builder.with(DIGITS, 1);
            }
            return builder.len(len).throwIfLengthSmall(true).build();
        });
        return this.text(config);
    }

    private static int min(boolean requireSomeKindOfSymbols) {
        return requireSomeKindOfSymbols ? 1 : 0;
    }

    public Text(BaseProviders faker) {
        super(faker);
    }

    public String text(TextRuleConfig textRuleConfig) {
        int numberOfRequiredSymbols;
        int fixedNumberOfCharacters = textRuleConfig.getFixedNumberOfCharacters();
        if (fixedNumberOfCharacters < (numberOfRequiredSymbols = textRuleConfig.getNumberOfRequiredSymbols())) {
            fixedNumberOfCharacters = numberOfRequiredSymbols;
        }
        char[] buffer = new char[fixedNumberOfCharacters];
        int idx = 0;
        int maxDiffSymbols = 0;
        for (int i = 0; i < textRuleConfig.textKeys.length; ++i) {
            maxDiffSymbols += textRuleConfig.textKeys[i].length;
        }
        if (maxDiffSymbols <= 256) {
            return this.textWithNotMoreThan256DiffSymbols(textRuleConfig, ((BaseProviders)this.faker).random().nextRandomBytes(2 * fixedNumberOfCharacters), fixedNumberOfCharacters, numberOfRequiredSymbols);
        }
        int numberOfRequired = 0;
        int[] required = Arrays.copyOf(textRuleConfig.required, textRuleConfig.required.length);
        block1: while (idx < buffer.length) {
            if (numberOfRequiredSymbols > numberOfRequired && numberOfRequiredSymbols - numberOfRequired == buffer.length - idx) {
                for (int j = 0; j < textRuleConfig.textKeys.length; ++j) {
                    while (required[j] > 0) {
                        buffer[idx++] = textRuleConfig.textKeys[j][((BaseProviders)this.faker).random().nextInt(textRuleConfig.textKeys[j].length)];
                        ++numberOfRequired;
                        int n = j;
                        required[n] = required[n] - 1;
                    }
                    if (idx == buffer.length) continue block1;
                }
                continue;
            }
            int index = ((BaseProviders)this.faker).random().nextInt(required.length);
            if (required[index] > 0) {
                ++numberOfRequired;
                int n = index;
                required[n] = required[n] - 1;
            }
            buffer[idx++] = textRuleConfig.textKeys[index][((BaseProviders)this.faker).random().nextInt(textRuleConfig.textKeys[index].length)];
        }
        return String.valueOf(buffer);
    }

    private String textWithNotMoreThan256DiffSymbols(TextRuleConfig textRuleConfig, byte[] bytes, int fixedNumberOfCharacters, int numberOfRequiredSymbols) {
        char[] buffer = new char[fixedNumberOfCharacters];
        int idx = 0;
        int bytesCounter = 0;
        int numberOfRequired = 0;
        int[] required = Arrays.copyOf(textRuleConfig.required, textRuleConfig.required.length);
        block0: while (idx < buffer.length) {
            int index;
            if (numberOfRequiredSymbols > numberOfRequired && numberOfRequiredSymbols - numberOfRequired == buffer.length - idx) {
                for (int j = 0; j < textRuleConfig.textKeys.length; ++j) {
                    while (required[j] > 0) {
                        buffer[idx++] = textRuleConfig.textKeys[j][(char)bytes[bytesCounter++] % textRuleConfig.textKeys[j].length];
                        ++numberOfRequired;
                        int n = j;
                        required[n] = required[n] - 1;
                    }
                    if (idx == buffer.length) continue block0;
                }
                continue;
            }
            if (required[index = (char)bytes[bytesCounter++] % textRuleConfig.textKeys.length] > 0) {
                ++numberOfRequired;
                int n = index;
                required[n] = required[n] - 1;
            }
            buffer[idx++] = textRuleConfig.textKeys[index][(char)bytes[bytesCounter++] % textRuleConfig.textKeys[index].length];
        }
        return String.valueOf(buffer);
    }

    private record TextConfigPojo(int length, boolean includeUppercase, boolean includeSpecial, boolean includeDigit) {
    }

    public static class TextRuleConfig {
        private final char[][] textKeys;
        private final int[] required;
        private final int fixedNumberOfCharacters;
        private final int numberOfRequiredSymbols;

        private TextRuleConfig(int fixedNumberOfCharacters, Map<String, Integer> map, int numberOfRequiredSymbols) {
            assert (numberOfRequiredSymbols >= 0);
            assert (fixedNumberOfCharacters >= numberOfRequiredSymbols);
            this.fixedNumberOfCharacters = fixedNumberOfCharacters;
            this.numberOfRequiredSymbols = numberOfRequiredSymbols;
            this.textKeys = new char[map.size()][];
            this.required = new int[map.size()];
            int i = 0;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                this.textKeys[i] = entry.getKey().toCharArray();
                this.required[i] = entry.getValue();
                ++i;
            }
        }

        public int getFixedNumberOfCharacters() {
            return this.fixedNumberOfCharacters;
        }

        public int getNumberOfRequiredSymbols() {
            return this.numberOfRequiredSymbols;
        }
    }

    public static class TextSymbolsBuilder {
        private int length;
        private final Map<String, Integer> map = new HashMap<String, Integer>();
        private boolean throwIfLengthSmall = false;

        private TextSymbolsBuilder() {
        }

        public static TextSymbolsBuilder builder() {
            return new TextSymbolsBuilder();
        }

        public TextSymbolsBuilder with(String listOfSymbols, int times) {
            if (times < 0) {
                throw new IllegalArgumentException("times should be non-negative: " + times);
            }
            this.map.put(listOfSymbols, times);
            return this;
        }

        public TextSymbolsBuilder with(String listOfSymbols) {
            return this.with(listOfSymbols, 0);
        }

        public TextSymbolsBuilder len(int len) {
            this.length = len;
            return this;
        }

        public TextSymbolsBuilder throwIfLengthSmall(boolean throwIfLengthSmall) {
            this.throwIfLengthSmall = throwIfLengthSmall;
            return this;
        }

        public TextRuleConfig build() {
            int minSize = this.map.values().stream().filter(t -> t > 0).reduce(0, Integer::sum);
            if (minSize > this.length && this.throwIfLengthSmall) {
                throw new IllegalArgumentException("Min length (%s) should be not smaller than number of required characters (%s)".formatted(this.length, minSize));
            }
            return new TextRuleConfig(this.length, this.map, minSize);
        }
    }
}

