/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.shaded.curiousoddman.rgxgen.util.chars;

import java.util.Arrays;
import java.util.stream.Stream;
import net.datafaker.shaded.curiousoddman.rgxgen.util.chars.CharList;
import net.datafaker.shaded.curiousoddman.rgxgen.util.chars.CharPredicate;

public class CharArrayList
extends CharList {
    private char[] elementData;
    private int size;

    public CharArrayList(char[] arr) {
        this.elementData = arr;
        this.size = arr.length;
    }

    public CharArrayList(int size) {
        this.elementData = new char[size];
        this.size = 0;
    }

    public CharArrayList(char[] arr, int size) {
        this.elementData = arr;
        this.size = size;
    }

    private static int newLength(int oldLength, int minGrowth, int prefGrowth) {
        int prefLength = oldLength + Math.max(minGrowth, prefGrowth);
        if (prefLength <= 0x7FFFFFF7) {
            return prefLength;
        }
        return oldLength + Math.min(minGrowth, prefLength);
    }

    @Override
    public CharList copy() {
        char[] arr = new char[this.size];
        System.arraycopy(this.elementData, 0, arr, 0, this.size);
        return new CharArrayList(arr);
    }

    @Override
    public void add(int c) {
        if (this.size == this.elementData.length) {
            this.grow();
        }
        this.elementData[this.size] = (char)c;
        ++this.size;
    }

    @Override
    public Stream<Character> stream() {
        return new String(this.elementData, 0, this.size).chars().mapToObj(i -> Character.valueOf((char)i));
    }

    @Override
    public void addAll(CharList charList) {
        charList.appendTo(this);
    }

    @Override
    public void addAll(char[] srcArr) {
        this.addAll(srcArr, srcArr.length);
    }

    @Override
    public void addAll(char[] srcArr, int srcLength) {
        if (srcLength > this.elementData.length - this.size) {
            this.grow(this.size + srcLength);
        }
        System.arraycopy(srcArr, 0, this.elementData, this.size, srcLength);
        this.size += srcLength;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public char get(int index) {
        return this.elementData[index];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void sort() {
        Arrays.sort(this.elementData, 0, this.size);
    }

    @Override
    public CharList except(CharPredicate predicate) {
        char[] arr = new char[this.size];
        int filteredSize = 0;
        for (char e : this.elementData) {
            if (predicate.test(e)) continue;
            arr[filteredSize] = e;
            ++filteredSize;
        }
        return new CharArrayList(arr, filteredSize);
    }

    @Override
    public boolean contains(char ch) {
        for (char e : this.elementData) {
            if (e != ch) continue;
            return true;
        }
        return false;
    }

    @Override
    public void appendTo(CharList targetList) {
        targetList.addAll(this.elementData, this.size);
    }

    private void grow() {
        this.grow(this.size + 1);
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int newCapacity = CharArrayList.newLength(oldCapacity, minCapacity - oldCapacity, oldCapacity >> 1);
        this.elementData = Arrays.copyOf(this.elementData, newCapacity);
    }

    public String toString() {
        if (this.elementData == null) {
            return "null";
        }
        int iMax = this.size - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(this.elementData[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }
}

