/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.shaded.curiousoddman.rgxgen.visitors;

import java.math.BigInteger;
import java.util.Optional;
import java.util.function.Function;
import net.datafaker.shaded.curiousoddman.rgxgen.config.RgxGenOption;
import net.datafaker.shaded.curiousoddman.rgxgen.config.RgxGenProperties;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.Choice;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.FinalSymbol;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.Group;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.GroupRef;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.Node;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.NotSymbol;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.Repeat;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.Sequence;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.SymbolSet;
import net.datafaker.shaded.curiousoddman.rgxgen.util.Util;
import net.datafaker.shaded.curiousoddman.rgxgen.visitors.NodeVisitor;

public class UniqueValuesCountingVisitor
implements NodeVisitor {
    private final Node aParentNode;
    private final RgxGenProperties aProperties;
    private Optional<BigInteger> aCount = Optional.of(BigInteger.ZERO);

    public UniqueValuesCountingVisitor(RgxGenProperties properties) {
        this(null, properties);
    }

    public UniqueValuesCountingVisitor(Node parentNode, RgxGenProperties properties) {
        this.aParentNode = parentNode;
        this.aProperties = properties;
    }

    private static Optional<BigInteger> countSeparately(Node parentNode, Node node, RgxGenProperties properties) {
        UniqueValuesCountingVisitor countingVisitor = new UniqueValuesCountingVisitor(parentNode, properties);
        node.visit(countingVisitor);
        return countingVisitor.aCount;
    }

    private void applyOrSkip(Function<BigInteger, Optional<BigInteger>> func) {
        this.aCount = this.aCount.flatMap(func);
    }

    @Override
    public void visit(SymbolSet node) {
        this.applyOrSkip(v -> {
            int size = RgxGenOption.CASE_INSENSITIVE.getFromPropertiesOrDefault(this.aProperties) != false ? node.getCaseInsensitiveSymbolSetIndexer().size() : node.getSymbolSetIndexer().size();
            return Optional.of(v.add(BigInteger.valueOf(size)));
        });
    }

    @Override
    public void visit(Choice node) {
        for (Node child_node : node.getNodes()) {
            this.applyOrSkip(v -> UniqueValuesCountingVisitor.countSeparately(node, child_node, this.aProperties).map(v::add));
        }
    }

    @Override
    public void visit(FinalSymbol node) {
        if (RgxGenOption.CASE_INSENSITIVE.getFromPropertiesOrDefault(this.aProperties).booleanValue()) {
            this.applyOrSkip(v -> Optional.of(v.add(Util.countCaseInsensitiveVariations(node.getValue()))));
        } else {
            this.applyOrSkip(v -> Optional.of(v.add(BigInteger.ONE)));
        }
    }

    @Override
    public void visit(Repeat node) {
        if (this.aCount.isPresent()) {
            UniqueValuesCountingVisitor countingVisitor = new UniqueValuesCountingVisitor(node, this.aProperties);
            node.getNode().visit(countingVisitor);
            if (node.getMax() < 0 || !countingVisitor.aCount.isPresent()) {
                this.aCount = Optional.empty();
            } else {
                BigInteger currentValue = this.aCount.get();
                BigInteger nodesValue = countingVisitor.aCount.get();
                for (int i = node.getMin(); i <= node.getMax(); ++i) {
                    currentValue = currentValue.add(nodesValue.pow(i));
                }
                this.aCount = Optional.of(currentValue);
            }
        }
    }

    @Override
    public void visit(Sequence node) {
        if (this.aCount.isPresent()) {
            for (Node child_node : node.getNodes()) {
                Optional<BigInteger> count = UniqueValuesCountingVisitor.countSeparately(node, child_node, this.aProperties);
                this.applyOrSkip(v -> {
                    if (!count.isPresent()) {
                        return Optional.empty();
                    }
                    if (v.equals(BigInteger.ZERO)) {
                        return count;
                    }
                    BigInteger subCount = (BigInteger)count.get();
                    return Optional.of(subCount.equals(BigInteger.ZERO) ? v : v.multiply(subCount));
                });
            }
        }
    }

    @Override
    public void visit(NotSymbol node) {
        this.aCount = Optional.empty();
    }

    @Override
    public void visit(GroupRef groupRef) {
        if (this.aParentNode != null && (this.aParentNode instanceof Repeat || this.aParentNode instanceof Choice)) {
            this.aCount = this.aCount.map(v -> v.add(BigInteger.ONE));
        }
    }

    @Override
    public void visit(Group group) {
        group.getNode().visit(this);
    }

    public Optional<BigInteger> getEstimation() {
        return this.aCount;
    }
}

