/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.transformations;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.datafaker.sequence.FakeSequence;
import net.datafaker.transformations.Field;
import net.datafaker.transformations.Schema;
import net.datafaker.transformations.Transformer;

public class TomlTransformer<IN>
implements Transformer<IN, String> {
    @Override
    public String apply(IN input, Schema<IN, ?> schema) {
        if (schema == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.writeSchema(sb, input, schema, "");
        int len = sb.length();
        int sepLen = LINE_SEPARATOR.length();
        if (len >= sepLen && sb.lastIndexOf(LINE_SEPARATOR, len - sepLen) >= 0) {
            sb.setLength(len - sepLen);
        }
        return sb.toString();
    }

    @Override
    public String generate(Iterable<IN> input, Schema<IN, ?> schema) {
        FakeSequence fs;
        if (input instanceof FakeSequence && (fs = (FakeSequence)input).isInfinite()) {
            throw new IllegalArgumentException("The sequence should be finite of size: " + String.valueOf(fs));
        }
        StringJoiner joiner = new StringJoiner(LINE_SEPARATOR);
        for (IN in : input) {
            joiner.add((CharSequence)this.apply((Object)in, (Schema)schema));
        }
        return joiner.toString();
    }

    @Override
    public String generate(Schema<IN, ?> schema, int limit) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < limit; ++i) {
            sb.append((String)this.apply((Object)null, (Schema)schema));
            if (i >= limit - 1) continue;
            sb.append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    @Override
    public String getStartStream(Schema<IN, ?> schema) {
        return "";
    }

    @Override
    public String getEndStream() {
        return "";
    }

    private void writeSchema(StringBuilder sb, IN input, Schema<IN, ?> schema, String pathPrefix) {
        Field<IN, ?>[] fields = schema.getFields();
        HashSet<String> seen = new HashSet<String>();
        for (Field<IN, ?> f : fields) {
            String key = f.getName();
            if (!seen.add(key)) continue;
            Object val = f.transform(input);
            this.writeValue(sb, key, pathPrefix, val);
        }
    }

    private void writeValue(StringBuilder sb, String key, String pathPrefix, Object val) {
        String fullPath;
        String string = fullPath = pathPrefix.isEmpty() ? key : pathPrefix + "." + key;
        if (val instanceof Schema) {
            Schema nested = (Schema)val;
            sb.append("[").append(fullPath).append("]").append(LINE_SEPARATOR);
            this.writeSchema(sb, null, nested, fullPath);
            return;
        }
        if (val instanceof Collection) {
            Collection col = (Collection)val;
            if (col.isEmpty()) {
                sb.append(key).append(" = []").append(LINE_SEPARATOR);
                return;
            }
            Object first = col.iterator().next();
            if (first instanceof Schema) {
                for (Object item : col) {
                    sb.append("[[").append(fullPath).append("]]").append(LINE_SEPARATOR);
                    this.writeSchema(sb, null, (Schema)item, fullPath);
                }
            } else {
                String array = col.stream().map(this::value2String).collect(Collectors.joining(", "));
                sb.append(key).append(" = [ ").append(array).append(" ]").append(LINE_SEPARATOR);
            }
            return;
        }
        if (val != null && val.getClass().isArray()) {
            this.handleArray(sb, key, val);
            return;
        }
        sb.append(key).append(" = ").append(this.value2String(val)).append(LINE_SEPARATOR);
    }

    private void handleArray(StringBuilder sb, String key, Object array) {
        int length = Array.getLength(array);
        if (length == 0) {
            sb.append(key).append(" = []").append(LINE_SEPARATOR);
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            list.add(Array.get(array, i));
        }
        String joined = list.stream().map(this::value2String).collect(Collectors.joining(", "));
        sb.append(key).append(" = [ ").append(joined).append(" ]").append(LINE_SEPARATOR);
    }

    private String value2String(Object val) {
        if (val == null) {
            return "null";
        }
        if (val instanceof Number || val instanceof Boolean) {
            return val.toString();
        }
        String s = String.valueOf(val).replace("\\", "\\\\").replace("\"", "\\\"");
        return "\"" + s + "\"";
    }
}

