/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.transformations;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.StringJoiner;
import net.datafaker.sequence.FakeSequence;
import net.datafaker.transformations.CompositeField;
import net.datafaker.transformations.Field;
import net.datafaker.transformations.Schema;
import net.datafaker.transformations.Transformer;

public class XmlTransformer<IN>
implements Transformer<IN, CharSequence> {
    private static final Map<Character, String> ESCAPING_MAP = XmlTransformer.createEscapeMap();
    private static final int INDENTATION_STEP = 4;
    private int tagIndex = 0;
    private final boolean pretty;

    private XmlTransformer(boolean pretty) {
        this.pretty = pretty;
    }

    @Override
    public CharSequence apply(IN input, Schema<IN, ?> schema) {
        StringBuilder sb = new StringBuilder();
        Arrays.stream(schema.getFields()).forEach(it -> this.apply(input, sb, (Field<IN, ?>)it));
        return sb.toString();
    }

    @Override
    public String generate(Iterable<IN> input, Schema<IN, ?> schema) {
        FakeSequence fakeSequence;
        if (input instanceof FakeSequence && (fakeSequence = (FakeSequence)input).isInfinite()) {
            throw new IllegalArgumentException("The sequence should be finite of size: " + String.valueOf(fakeSequence));
        }
        StringJoiner data = new StringJoiner(LINE_SEPARATOR);
        for (IN in : input) {
            data.add((CharSequence)this.apply((Object)in, (Schema)schema));
        }
        return data.toString();
    }

    @Override
    public CharSequence generate(Schema<IN, ?> schema, int limit) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < limit; ++i) {
            sb.append((CharSequence)this.apply((Object)null, (Schema)schema));
            if (i >= limit - 1) continue;
            sb.append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    @Override
    public String getStartStream(Schema<IN, ?> schema) {
        return "";
    }

    @Override
    public String getEndStream() {
        return "";
    }

    private void apply(IN input, StringBuilder sb, Field<IN, ?> xmlNode) {
        if (this.pretty && this.tagIndex > 0) {
            sb.append(System.lineSeparator()).append(this.offset(this.tagIndex));
        }
        String tag = xmlNode.getName().trim();
        sb.append("<").append(tag);
        if (xmlNode instanceof CompositeField) {
            Field<IN, OUT>[] attrs = ((CompositeField)xmlNode).getFields();
            this.applyAttributes(input, sb, attrs);
            xmlNode = Arrays.stream(attrs).filter(inField -> !this.isAttribute(inField.getName())).findFirst().orElse(null);
        }
        this.applyTag(input, sb, xmlNode, tag);
    }

    private void applyTag(IN input, StringBuilder sb, Field<IN, ?> field, String tag) {
        if (field == null) {
            this.applyValue(sb, tag, null);
            return;
        }
        Object xmlNodeValue = field.transform(input);
        if (xmlNodeValue instanceof Collection) {
            Collection children = (Collection)xmlNodeValue;
            if (children.isEmpty()) {
                this.applyValue(sb, tag, null);
            } else {
                sb.append(">");
                ++this.tagIndex;
                for (Object xmlNodeElem : children) {
                    this.apply(input, sb, (Field)xmlNodeElem);
                }
                --this.tagIndex;
                if (this.pretty) {
                    sb.append(System.lineSeparator()).append(this.offset(this.tagIndex));
                }
                sb.append("</").append(tag).append(">");
            }
        } else if (xmlNodeValue instanceof String) {
            this.applyValue(sb, tag, (String)xmlNodeValue);
        } else if (xmlNodeValue == null) {
            this.applyValue(sb, tag, null);
        }
    }

    private boolean isAttribute(String name) {
        return name != null;
    }

    private void applyAttributes(IN input, StringBuilder sb, Field<IN, ?>[] attrs) {
        for (Field<IN, ?> attr : attrs) {
            String name = attr.getName();
            if (!this.isAttribute(name)) continue;
            String value = (String)attr.transform(input);
            sb.append(" ").append(name).append("=\"").append(this.escape(value)).append("\"");
        }
    }

    private void applyValue(StringBuilder sb, String tag, String xmlNodeValue) {
        if (xmlNodeValue != null) {
            sb.append(">");
            sb.append(this.escape(xmlNodeValue));
            sb.append("</").append(tag).append(">");
        } else {
            sb.append("/>");
        }
    }

    private String offset(int length) {
        return " ".repeat(Math.max(0, length * 4));
    }

    private String escape(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            sb.append(ESCAPING_MAP.getOrDefault(Character.valueOf(c), String.valueOf(c)));
        }
        return sb.toString();
    }

    private static Map<Character, String> createEscapeMap() {
        return Map.of(Character.valueOf('<'), "&lt;", Character.valueOf('>'), "&gt;", Character.valueOf('&'), "&amp;", Character.valueOf('\''), "&apos;", Character.valueOf('\"'), "&quot;");
    }

    public static class XmlTransformerBuilder<IN> {
        private boolean pretty = false;

        public XmlTransformerBuilder<IN> pretty(boolean pretty) {
            this.pretty = pretty;
            return this;
        }

        public XmlTransformer<IN> build() {
            return new XmlTransformer(this.pretty);
        }
    }
}

