/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.disq;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.intelie.disq.Buffer;
import net.intelie.disq.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSerializer<T>
implements Serializer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSerializer.class);

    @Override
    public void serialize(Buffer buffer, T obj) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(buffer.write());){
            oos.writeObject(obj);
            oos.flush();
        }
    }

    @Override
    public T deserialize(Buffer buffer) throws IOException {
        Throwable throwable = null;
        try (ObjectInputStream ois = new ObjectInputStream(buffer.read());){
            Object object = ois.readObject();
            return (T)object;
        }
        catch (ClassNotFoundException e) {
            try {
                LOGGER.info("Exception on default deserializer", (Throwable)e);
                throw new IOException(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

