/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.disq;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.intelie.disq.DefaultSerializer;
import net.intelie.disq.DiskRawQueue;
import net.intelie.disq.Disq;
import net.intelie.disq.NamedThreadFactory;
import net.intelie.disq.PersistentQueue;
import net.intelie.disq.Processor;
import net.intelie.disq.RawQueue;
import net.intelie.disq.SerializerFactory;

public class DisqBuilder<T> {
    private final Processor<T> processor;
    private SerializerFactory<T> serializer = new DefaultSerializer();
    private Path directory = null;
    private long maxSize = Long.MAX_VALUE;
    private boolean flushOnPop = true;
    private boolean flushOnPush = true;
    private long autoFlushMs = -1L;
    private boolean deleteOldestOnOverflow = true;
    private int initialBufferCapacity = 4096;
    private int maxBufferCapacity = -1;
    private int fallbackBufferCapacity = 0;
    private int threadCount = 1;
    private ThreadFactory threadFactory = Executors.defaultThreadFactory();

    public DisqBuilder(Processor<T> processor) {
        this.processor = processor;
    }

    public DisqBuilder<T> setSerializer(SerializerFactory<T> serializer) {
        this.serializer = serializer;
        return this;
    }

    public DisqBuilder<T> setDirectory(Path directory) {
        this.directory = directory;
        return this;
    }

    public DisqBuilder<T> setDirectory(String first, String ... rest) {
        return this.setDirectory(Paths.get(first, rest));
    }

    public DisqBuilder<T> setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public DisqBuilder<T> setFlushOnPop(boolean flushOnPop) {
        this.flushOnPop = flushOnPop;
        return this;
    }

    public DisqBuilder<T> setFlushOnPush(boolean flushOnPush) {
        this.flushOnPush = flushOnPush;
        return this;
    }

    public DisqBuilder<T> setAutoFlushMs(long autoFlushMs) {
        this.autoFlushMs = autoFlushMs;
        return this;
    }

    public DisqBuilder<T> setDeleteOldestOnOverflow(boolean deleteOldestOnOverflow) {
        this.deleteOldestOnOverflow = deleteOldestOnOverflow;
        return this;
    }

    public DisqBuilder<T> setInitialBufferCapacity(int initialBufferCapacity) {
        this.initialBufferCapacity = initialBufferCapacity;
        return this;
    }

    public DisqBuilder<T> setMaxBufferCapacity(int maxBufferCapacity) {
        this.maxBufferCapacity = maxBufferCapacity;
        return this;
    }

    public DisqBuilder<T> setFallbackBufferCapacity(int fallbackBufferCapacity) {
        this.fallbackBufferCapacity = fallbackBufferCapacity;
        return this;
    }

    public DisqBuilder<T> setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public DisqBuilder<T> setNamedThreadFactory(String nameFormat) {
        return this.setThreadFactory(new NamedThreadFactory(nameFormat));
    }

    public DisqBuilder<T> setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public Disq<T> build() {
        return this.build(false);
    }

    public Disq<T> build(boolean paused) {
        PersistentQueue<T> queue = this.buildPersistentQueue();
        queue.setPopPaused(paused);
        return new Disq<T>(this.threadFactory, this.threadCount, this.autoFlushMs, this.processor, queue);
    }

    public PersistentQueue<T> buildPersistentQueue() {
        return this.buildPersistentQueue(this.buildRawQueue());
    }

    public PersistentQueue<T> buildPersistentQueue(RawQueue rawQueue) {
        return new PersistentQueue<T>(rawQueue, this.serializer, this.initialBufferCapacity, this.maxBufferCapacity, this.fallbackBufferCapacity);
    }

    public DiskRawQueue buildRawQueue() {
        return new DiskRawQueue(this.directory, this.maxSize, this.flushOnPop, this.flushOnPush, this.deleteOldestOnOverflow);
    }
}

