/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.disq;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.intelie.disq.ArrayRawQueue;
import net.intelie.disq.Buffer;
import net.intelie.disq.ObjectPool;
import net.intelie.disq.RawQueue;
import net.intelie.disq.Serializer;
import net.intelie.disq.SerializerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentQueue<T>
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistentQueue.class);
    private static final long MAX_WAIT = 10000000000L;
    private final ObjectPool<Slot> pool;
    private final ArrayRawQueue fallback;
    private final RawQueue queue;
    private final SerializerFactory<T> serializerFactory;
    private final int initialBufferCapacity;
    private final int maxBufferCapacity;
    private final Lock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();
    private final Condition notEmpty = this.lock.newCondition();
    private boolean popPaused;
    private boolean pushPaused;

    public PersistentQueue(RawQueue queue, SerializerFactory<T> serializer, int initialBufferCapacity, int maxBufferCapacity) {
        this(queue, serializer, initialBufferCapacity, maxBufferCapacity, 0);
    }

    public PersistentQueue(RawQueue queue, SerializerFactory<T> serializer, int initialBufferCapacity, int maxBufferCapacity, int fallbackBufferCapacity) {
        this.fallback = new ArrayRawQueue(fallbackBufferCapacity, true);
        this.queue = queue;
        this.serializerFactory = serializer;
        this.initialBufferCapacity = initialBufferCapacity;
        this.maxBufferCapacity = maxBufferCapacity;
        this.pool = new ObjectPool<Slot>(() -> new Slot());
    }

    public RawQueue rawQueue() {
        return this.queue;
    }

    public ArrayRawQueue fallbackQueue() {
        return this.fallback;
    }

    public void setPopPaused(boolean popPaused) {
        this.lock.lock();
        try {
            this.popPaused = popPaused;
            this.notFull.signalAll();
            this.notEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setPushPaused(boolean pushPaused) {
        this.lock.lock();
        try {
            this.pushPaused = pushPaused;
            this.notFull.signalAll();
            this.notEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reopen() throws IOException {
        this.queue.reopen();
        this.fallback.reopen();
    }

    public long bytes() {
        return this.queue.bytes() + this.fallback.bytes();
    }

    public long count() {
        return this.queue.count() + this.fallback.count();
    }

    public long remainingBytes() {
        return this.queue.remainingBytes();
    }

    public long remainingCount() {
        return this.queue.remainingCount();
    }

    public void clear() throws IOException {
        this.queue.clear();
        this.fallback.clear();
    }

    public void flush() throws IOException {
        this.queue.flush();
        this.fallback.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T blockingPop(long amount, TimeUnit unit) throws InterruptedException, IOException {
        try (ObjectPool.Ref ref = this.pool.acquire();){
            Slot slot = (Slot)ref.obj();
            this.lock.lockInterruptibly();
            try {
                long target = System.nanoTime() + unit.toNanos(amount);
                while (!this.notifyingPop(slot.buffer)) {
                    long wait = Math.min(10000000000L, target - System.nanoTime());
                    if (wait <= 0L) {
                        T t = null;
                        return t;
                    }
                    this.notEmpty.awaitNanos(wait);
                }
            }
            finally {
                this.lock.unlock();
            }
            T t = this.safeDeserialize(slot.buffer, slot.serializer);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T blockingPop() throws InterruptedException, IOException {
        try (ObjectPool.Ref ref = this.pool.acquire();){
            Slot slot = (Slot)ref.obj();
            this.lock.lockInterruptibly();
            try {
                while (!this.notifyingPop(slot.buffer)) {
                    this.notEmpty.awaitNanos(10000000000L);
                }
            }
            finally {
                this.lock.unlock();
            }
            T t = this.safeDeserialize(slot.buffer, slot.serializer);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean blockingPush(T obj, long amount, TimeUnit unit) throws InterruptedException, IOException {
        try (ObjectPool.Ref ref = this.pool.acquire();){
            Slot slot = (Slot)ref.obj();
            this.serialize(obj, slot.buffer, slot.serializer);
            this.lock.lockInterruptibly();
            try {
                long target = System.nanoTime() + unit.toNanos(amount);
                while (!this.notifyingPush(slot.buffer)) {
                    long wait = Math.min(10000000000L, target - System.nanoTime());
                    if (wait <= 0L) {
                        boolean bl = false;
                        return bl;
                    }
                    this.notFull.awaitNanos(wait);
                }
            }
            finally {
                this.lock.unlock();
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean blockingPush(T obj) throws InterruptedException, IOException {
        try (ObjectPool.Ref ref = this.pool.acquire();){
            Slot slot = (Slot)ref.obj();
            this.serialize(obj, slot.buffer, slot.serializer);
            this.lock.lockInterruptibly();
            try {
                while (!this.notifyingPush(slot.buffer)) {
                    this.notFull.awaitNanos(10000000000L);
                }
            }
            finally {
                this.lock.unlock();
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T pop() throws IOException {
        try (ObjectPool.Ref ref = this.pool.acquire();){
            Slot slot;
            block18: {
                slot = (Slot)ref.obj();
                this.lock.lock();
                if (this.notifyingPop(slot.buffer)) break block18;
                T t = null;
                return t;
                finally {
                    this.lock.unlock();
                }
            }
            T t = this.safeDeserialize(slot.buffer, slot.serializer);
            return t;
        }
    }

    private T safeDeserialize(Buffer buffer, Serializer<T> serializer) throws IOException {
        try {
            return serializer.deserialize(buffer);
        }
        catch (Throwable e) {
            this.queue.notifyFailedRead();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean push(T obj) throws IOException {
        try (ObjectPool.Ref ref = this.pool.acquire();){
            Slot slot = (Slot)ref.obj();
            this.serialize(obj, slot.buffer, slot.serializer);
            this.lock.lock();
            try {
                if (!this.notifyingPush(slot.buffer)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
            boolean bl = true;
            return bl;
        }
    }

    private boolean notifyingPop(Buffer buffer) {
        if (this.popPaused) {
            return false;
        }
        if (!this.innerPop(buffer)) {
            return false;
        }
        this.notFull.signalAll();
        return true;
    }

    private boolean notifyingPush(Buffer buffer) {
        if (this.pushPaused) {
            return false;
        }
        if (!this.innerPush(buffer)) {
            return false;
        }
        this.notEmpty.signal();
        return true;
    }

    private void serialize(T obj, Buffer buffer, Serializer<T> serializer) throws IOException {
        if (obj == null) {
            throw new NullPointerException("Null elements not allowed in persistent queue.");
        }
        buffer.setCount(0, false);
        serializer.serialize(buffer, obj);
    }

    public T peek() throws IOException {
        try (ObjectPool.Ref ref = this.pool.acquire();){
            Slot slot = (Slot)ref.obj();
            if (!this.innerPeek(slot.buffer)) {
                T t = null;
                return t;
            }
            T t = this.safeDeserialize(slot.buffer, slot.serializer);
            return t;
        }
    }

    private boolean innerPeek(Buffer buffer) {
        if (this.popPaused) {
            return false;
        }
        if (this.fallback.peek(buffer)) {
            return true;
        }
        try {
            return this.queue.peek(buffer);
        }
        catch (IOException e) {
            LOGGER.info("Error peeking", (Throwable)e);
            return false;
        }
    }

    private boolean innerPop(Buffer buffer) {
        if (this.fallback.pop(buffer)) {
            return true;
        }
        try {
            return this.queue.pop(buffer);
        }
        catch (IOException e) {
            LOGGER.info("Error popping", (Throwable)e);
            return false;
        }
    }

    private boolean innerPush(Buffer buffer) {
        try {
            return this.queue.push(buffer);
        }
        catch (IOException e) {
            LOGGER.info("Error pushing", (Throwable)e);
            return this.fallback.push(buffer);
        }
    }

    @Override
    public void close() {
        this.queue.close();
    }

    private class Slot {
        private final Buffer buffer;
        private final Serializer<T> serializer;

        private Slot() {
            this.buffer = new Buffer(PersistentQueue.this.initialBufferCapacity, PersistentQueue.this.maxBufferCapacity);
            this.serializer = PersistentQueue.this.serializerFactory.create();
        }
    }
}

