/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.disq;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class StateFile
implements Closeable {
    public static final short MAX_FILES = 121;
    public static final short MAX_FILE_ID = 32670;
    public static final int EXPECTED_SIZE = 512;
    public static final long MIN_QUEUE_SIZE = 61952L;
    public static final long MAX_QUEUE_SIZE = 259845521287L;
    private final RandomAccessFile randomWrite;
    private final ByteBuffer buffer = ByteBuffer.allocate(512);
    private int readFile;
    private int writeFile;
    private int readPosition;
    private int writePosition;
    private long count;
    private long bytes;
    private int[] fileCounts = new int[121];
    private long unflushed;
    private boolean dirty;

    public StateFile(Path file) throws IOException {
        this.randomWrite = new RandomAccessFile(file.toFile(), "rw");
        if (Files.exists(file, new LinkOption[0]) && Files.size(file) == 512L) {
            try (DataInputStream stream = new DataInputStream(new FileInputStream(file.toFile()));){
                this.readFile = stream.readShort();
                this.writeFile = stream.readShort();
                this.readPosition = stream.readInt();
                this.writePosition = stream.readInt();
                this.count = stream.readLong();
                this.bytes = stream.readLong();
                for (int i = 0; i < 121; ++i) {
                    this.fileCounts[i] = stream.readInt();
                }
                this.unflushed = 0L;
                this.dirty = false;
            }
        } else {
            this.dirty = true;
        }
    }

    public boolean isInUse(int file) {
        int readFile = this.getReadFile();
        int writeFile = this.getWriteFile();
        boolean same = this.sameFileReadWrite();
        return same && readFile == file && (this.readPosition != 0 || this.writePosition != 0) || !same && readFile <= writeFile && readFile <= file && file <= writeFile || !same && readFile >= writeFile && (readFile <= file || file <= writeFile);
    }

    public void flush() throws IOException {
        if (!this.dirty) {
            return;
        }
        this.buffer.position(0);
        this.buffer.putShort((short)this.readFile);
        this.buffer.putShort((short)this.writeFile);
        this.buffer.putInt(this.readPosition);
        this.buffer.putInt(this.writePosition);
        this.buffer.putLong(this.count);
        this.buffer.putLong(this.bytes);
        for (int i = 0; i < 121; ++i) {
            this.buffer.putInt(this.fileCounts[i]);
        }
        this.randomWrite.seek(0L);
        this.randomWrite.write(this.buffer.array());
        this.unflushed = 0L;
        this.dirty = false;
    }

    public int getReadFile() {
        return this.readFile % 121;
    }

    public boolean sameFileReadWrite() {
        return this.readFile == this.writeFile;
    }

    public int advanceReadFile(long oldBytes) {
        int oldCount = this.fileCounts[this.getReadFile()];
        this.fileCounts[this.getReadFile()] = 0;
        this.count -= (long)oldCount;
        this.bytes -= oldBytes;
        ++this.readFile;
        this.readFile %= 32670;
        this.readPosition = 0;
        this.dirty = true;
        return this.readFile;
    }

    public int advanceWriteFile() {
        ++this.writeFile;
        this.writeFile %= 32670;
        this.writePosition = 0;
        this.dirty = true;
        return this.writeFile;
    }

    public long getReadPosition() {
        return this.readPosition;
    }

    public int getWriteFile() {
        return this.writeFile % 121;
    }

    public long getCount() {
        return this.count;
    }

    public long getBytes() {
        return this.bytes;
    }

    public int getNumberOfFiles() {
        return (this.writeFile >= this.readFile ? this.writeFile - this.readFile : 32670 - this.readFile + this.writeFile) + (this.writePosition > 0 ? 1 : 0);
    }

    public void addWriteCount(int bytes) {
        ++this.count;
        ++this.unflushed;
        this.bytes += (long)bytes;
        this.writePosition += bytes;
        int n = this.getWriteFile();
        this.fileCounts[n] = this.fileCounts[n] + 1;
        this.dirty = true;
    }

    public void addReadCount(int bytes) {
        --this.count;
        this.readPosition += bytes;
        int n = this.getReadFile();
        this.fileCounts[n] = this.fileCounts[n] - 1;
        this.dirty = true;
    }

    public void clear() {
        this.writeFile = 0;
        this.readFile = 0;
        this.writePosition = 0;
        this.readPosition = 0;
        this.bytes = 0L;
        this.count = 0L;
        this.unflushed = 0L;
        for (int i = 0; i < 121; ++i) {
            this.fileCounts[i] = 0;
        }
        this.dirty = true;
    }

    public long getWritePosition() {
        return this.writePosition;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.randomWrite.close();
    }

    public int getFileCount(int file) {
        return this.fileCounts[file];
    }

    public boolean fixCounts(long totalCount, long totalBytes) {
        if (totalBytes != this.bytes || totalCount != this.count) {
            this.bytes = totalBytes;
            this.count = totalCount;
            this.dirty = true;
            return true;
        }
        return false;
    }

    public boolean readFileEof() {
        return this.fileCounts[this.getReadFile()] <= 0;
    }

    public long getFlushedCount() {
        return this.count - this.unflushed;
    }

    public long getUnflushedCount() {
        return this.unflushed;
    }

    public boolean needsFlushBeforePop() {
        return this.unflushed > 0L && this.unflushed == this.count;
    }
}

