/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.FullPipe;
import net.intelie.pipes.HasHelp;
import net.intelie.pipes.HelpCollection;
import net.intelie.pipes.HelpData;
import net.intelie.pipes.Module;
import net.intelie.pipes.ModuleContext;
import net.intelie.pipes.Pipe;
import net.intelie.pipes.PipeCompiler;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertySource;
import net.intelie.pipes.SelectClause;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.RawNode;
import net.intelie.pipes.ast.SourceLocation;
import net.intelie.pipes.filters.Filter;
import net.intelie.pipes.generated.CharStream;
import net.intelie.pipes.generated.FilterParserCore;
import net.intelie.pipes.generated.FilterParserCoreTokenManager;
import net.intelie.pipes.generated.ParseException;
import net.intelie.pipes.generated.ParseExceptionMessage;
import net.intelie.pipes.generated.PipeParserCore;
import net.intelie.pipes.generated.PipeParserCoreTokenManager;
import net.intelie.pipes.generated.SimpleCharStream;
import net.intelie.pipes.generated.Token;
import net.intelie.pipes.modules.ArgQueueImpl;
import net.intelie.pipes.modules.CompilerContextImpl;

public abstract class PipeCompilers {
    public static final PipeStrategy<FullPipe> STRATEGY_FULL = new PipeStrategy<FullPipe>("full"){
        private static final long serialVersionUID = 1L;

        @Override
        public AstNode parse(PipeParserCore parser, CompilerContext config) throws ParseException {
            return parser.fullStart();
        }
    };
    public static final PipeStrategy<Pipe> STRATEGY_PIPE = new PipeStrategy<Pipe>("pipe"){
        private static final long serialVersionUID = 1L;

        @Override
        public AstNode parse(PipeParserCore parser, CompilerContext config) throws ParseException {
            return parser.start();
        }
    };
    public static final PipeStrategy<Object> STRATEGY_EXPRESSION = new PipeStrategy<Object>("expr"){
        private static final long serialVersionUID = 1L;

        @Override
        public AstNode parse(PipeParserCore parser, CompilerContext config) throws ParseException {
            return parser.expressionStart();
        }
    };
    public static final PipeStrategy<SelectClause> STRATEGY_SELECT = new PipeStrategy<SelectClause>("select"){
        private static final long serialVersionUID = 1L;

        @Override
        public AstNode parse(PipeParserCore parser, CompilerContext config) throws ParseException {
            return parser.selectStart();
        }
    };
    public static final FilterStrategy<Filter> STRATEGY_FILTER = new FilterStrategy<Filter>("filter"){
        private static final long serialVersionUID = 1L;

        @Override
        public AstNode parse(FilterParserCore parser, CompilerContext config) throws ParseException {
            return parser.start();
        }
    };
    public static final PipeStrategy<Module> STRATEGY_MODULE = new PipeStrategy<Module>("module"){
        private static final long serialVersionUID = 1L;

        @Override
        public AstNode parse(PipeParserCore parser, CompilerContext config) throws ParseException {
            return parser.moduleStart();
        }
    };
    public static final Strategy<HelpCollection> STRATEGY_MODULE_HELP = new Strategy<HelpCollection>("moduleHelp"){
        private static final long serialVersionUID = 1L;

        @Override
        public AstNode parse(String text, CompilerContext config) throws PipeException {
            ArrayList<HelpData> helps = new ArrayList<HelpData>();
            try {
                PipeParserCore parser = PipeCompilers.makePipeParser(PipeCompilers.makeStream(text));
                List nodes = parser.moduleLenient();
                for (AstNode node : nodes) {
                    try {
                        HelpData help;
                        Object o = config.compile(node);
                        if (!(o instanceof HasHelp) || (help = ((HasHelp)o).help()) == null) continue;
                        helps.add(help);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new RawNode((Object)new HelpCollection(helps));
        }
    };

    public static PipeCompiler<FullPipe> get() {
        return PipeCompilers.get(null, STRATEGY_FULL);
    }

    public static <T> PipeCompiler<T> get(Strategy<T> strategy) {
        return PipeCompilers.get(null, strategy);
    }

    public static PipeCompiler<FullPipe> get(PropertySource source) {
        return PipeCompilers.get(source, STRATEGY_FULL);
    }

    public static <T> PipeCompiler<T> get(PropertySource source, Strategy<T> strategy) {
        return new Impl<T>(CompilerContextImpl.createIfNeeded(source), strategy);
    }

    public static PipeException handle(Throwable e, Token token) {
        SourceLocation location = new SourceLocation(token.beginLine, token.beginColumn);
        return ParseExceptionMessage.handle((Throwable)e, (SourceLocation)location);
    }

    private static SimpleCharStream makeStream(String text) {
        return new SimpleCharStream((Reader)new StringReader(text));
    }

    private static PipeParserCore makePipeParser(String text) {
        return PipeCompilers.makePipeParser(PipeCompilers.makeStream(text));
    }

    private static FilterParserCore makeFilterParser(String text) {
        return PipeCompilers.makeFilterParser(PipeCompilers.makeStream(text));
    }

    private static PipeParserCore makePipeParser(SimpleCharStream stream) {
        PipeParserCoreTokenManager manager = new PipeParserCoreTokenManager((CharStream)stream);
        PipeParserCore parser = new PipeParserCore(manager);
        parser.enable_tracing();
        return parser;
    }

    private static FilterParserCore makeFilterParser(SimpleCharStream stream) {
        FilterParserCore parser = new FilterParserCore(new FilterParserCoreTokenManager((CharStream)stream));
        parser.enable_tracing();
        return parser;
    }

    public static abstract class Strategy<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;

        public Strategy(String name) {
            this.name = name;
        }

        public abstract AstNode parse(String var1, CompilerContext var2) throws PipeException;

        public T compile(String text, CompilerContext config) throws PipeException {
            try {
                return this.compile(this.parse(text, config), config);
            }
            catch (Throwable e) {
                throw PipeException.handle((Throwable)e);
            }
        }

        public T compile(AstNode node, CompilerContext config) throws PipeException {
            try {
                return (T)config.compile(node);
            }
            catch (Throwable e) {
                throw PipeException.handle((Throwable)e);
            }
        }

        public String toString() {
            return this.name;
        }
    }

    private static abstract class FilterStrategy<T>
    extends Strategy<T> {
        private static final long serialVersionUID = 1L;

        public FilterStrategy(String name) {
            super(name);
        }

        public abstract AstNode parse(FilterParserCore var1, CompilerContext var2) throws ParseException;

        @Override
        public AstNode parse(String text, CompilerContext config) throws PipeException {
            FilterParserCore parser = PipeCompilers.makeFilterParser(text);
            try {
                return this.parse(parser, config);
            }
            catch (Throwable e) {
                throw PipeCompilers.handle(e, parser.token);
            }
        }
    }

    private static abstract class PipeStrategy<T>
    extends Strategy<T> {
        private static final long serialVersionUID = 1L;

        public PipeStrategy(String name) {
            super(name);
        }

        public abstract AstNode parse(PipeParserCore var1, CompilerContext var2) throws ParseException;

        @Override
        public AstNode parse(String text, CompilerContext config) throws PipeException {
            PipeParserCore parser = PipeCompilers.makePipeParser(text);
            try {
                return this.parse(parser, config);
            }
            catch (Throwable e) {
                throw PipeCompilers.handle(e, parser.token);
            }
        }
    }

    private static class Impl<T>
    implements PipeCompiler<T> {
        private static final long serialVersionUID = 1L;
        private final CompilerContext context;
        private final Strategy<T> strategy;

        public Impl(CompilerContext context, Strategy<T> strategy) {
            this.context = context;
            this.strategy = strategy;
        }

        public AstNode parse(String code) throws PipeException {
            return this.strategy.parse(code, this.context);
        }

        public T compile(String code) throws PipeException {
            return this.strategy.compile(code, this.context);
        }

        public T compile(AstNode node) throws PipeException {
            return this.strategy.compile(node, this.context);
        }

        public ArgQueue compileToQueue(String ... codes) throws PipeException {
            AstNode[] nodes = new AstNode[codes.length];
            for (int i = 0; i < codes.length; ++i) {
                nodes[i] = this.parse(codes[i]);
            }
            return this.compileToQueue(nodes);
        }

        public ArgQueue compileToQueue(AstNode ... nodes) throws PipeException {
            return new ArgQueueImpl(this.context, Arrays.asList(nodes));
        }

        public Impl<FullPipe> full() {
            return new Impl<FullPipe>(this.context, STRATEGY_FULL);
        }

        public Impl<Pipe> pipe() {
            return new Impl<Pipe>(this.context, STRATEGY_PIPE);
        }

        public Impl<Object> expression() {
            return new Impl<Object>(this.context, STRATEGY_EXPRESSION);
        }

        public Impl<SelectClause> select() {
            return new Impl<SelectClause>(this.context, STRATEGY_SELECT);
        }

        public Impl<Filter> filter() {
            return new Impl<Filter>(this.context, STRATEGY_FILTER);
        }

        public Impl<Module> module() {
            return new Impl<Module>(this.context, STRATEGY_MODULE);
        }

        public Impl<HelpCollection> moduleHelp() {
            return new Impl<HelpCollection>(this.context, STRATEGY_MODULE_HELP);
        }

        public CompilerContext getContext() {
            return this.context;
        }

        public HelpCollection help() {
            return this.context.help();
        }

        public Impl<T> insideModule(ModuleContext moduleContext) {
            return this.withContext(this.context.insideModule(moduleContext));
        }

        public Impl<T> withModule(Module module) {
            return this.withContext(this.context.addModule(module));
        }

        public PipeCompiler<T> withSource(PropertySource source) {
            return this.withContext(CompilerContextImpl.createIfNeeded(source));
        }

        public Impl<T> withContext(CompilerContext context) {
            return new Impl<T>(context, this.strategy);
        }
    }
}

