/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import java.util.ArrayList;
import java.util.Arrays;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertySink;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;

@Export(value={"amap"})
@Help(key="aggregation-amap")
public class AMapAggregation
implements Aggregation,
Scalar {
    private static final long serialVersionUID = 1L;
    private final Scalar<Row> expr;
    private final Aggregation[] aggr;
    private final RowType type;
    private final Level level;
    private final long ttl;
    private final long weight;
    private final int size;

    public AMapAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Scalar)queue.scalar((Type)Type.ROW).get();
        this.aggr = this.extractInAggregation(queue, (Type<Row>)this.expr.type());
        queue.get(AstNode.class);
        this.size = this.aggr.length;
        this.type = this.extractOutType((Type<Row>)this.expr.type(), this.aggr);
        this.level = Arrays.stream(this.aggr).map(Expression::level).reduce((xva$0, xva$1) -> Level.min((Level[])new Level[]{xva$0, xva$1})).orElse((Level)Level.CONSTANT);
        this.ttl = Arrays.stream(this.aggr).mapToLong(Expression::ttl).reduce(Long::max).orElse(1L);
        this.weight = Arrays.stream(this.aggr).mapToLong(x -> x.weight() + 8L).sum();
    }

    private Aggregation[] extractInAggregation(ArgQueue queue, Type<Row> type) throws PipeException {
        RowFields fields = RowType.getFields(type);
        PipeException.check((fields != null ? 1 : 0) != 0, (String)"amap aggregation requires a strongly-typed row, you passed a %s", (Object[])new Object[]{type});
        Aggregation[] aggrs = new Aggregation[fields.size()];
        for (int i = 0; i < aggrs.length; ++i) {
            aggrs[i] = (Aggregation)queue.copyFromHere().withContext(queue.context().newChildSource(queue.metadata().withType(fields.type(i)))).aggregation((Type)Type.OBJECT).get();
        }
        return aggrs;
    }

    private RowType extractOutType(Type<Row> type, Aggregation[] aggr) throws PipeException {
        RowFields fields = ((RowType)Type.extract(type, RowType.class)).fields();
        ClauseInfo timestamp = this.makeClause(0, fields.timestamp(), aggr);
        ClauseInfo group = this.makeClause(timestamp.size(), fields.group(), aggr);
        ClauseInfo select = this.makeClause(timestamp.size() + group.size(), fields.select(), aggr);
        return new RowType(new RowFields(timestamp, group, select));
    }

    private ClauseInfo makeClause(int start, ClauseInfo inputClause, Aggregation[] aggr) {
        ArrayList<FieldInfo> list = new ArrayList<FieldInfo>();
        for (FieldInfo info : inputClause) {
            list.add(new FieldInfo(info.name(), aggr[start++].type()));
        }
        return new ClauseInfo(list);
    }

    public State newState(int flips) {
        return new MyState(flips);
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        return "amap(" + this.expr + ", " + this.aggr[0] + ")";
    }

    public Level level() {
        return this.level;
    }

    public long ttl() {
        return this.ttl;
    }

    public long weight() {
        return 8L + this.weight;
    }

    public FullMerger newMerger() {
        return new MyFullMerger();
    }

    public InsertMerger newInsertMerger() {
        return new MyInsertMerger();
    }

    public Object eval(Scope parent, Tree tree, WindowBounds bounds) {
        Object[] obj = new Object[this.size];
        MyTree myTree = (MyTree)tree;
        for (int i = 0; i < this.size; ++i) {
            obj[i] = this.aggr[i].eval(parent, myTree.trees[i], bounds);
        }
        return new ArrayRow(obj);
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr}).defer((Expression[])this.aggr);
    }

    public Object eval(Scope parent, Object obj) {
        Row row = (Row)this.expr.eval(parent, obj);
        Object[] objs = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            objs[i] = Level.asScalar((Expression)this.aggr[i]).eval(new Scope(parent, obj), row != null && i < row.size() ? row.get(i) : null);
        }
        return new ArrayRow(objs);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.expr.visit(parent, visitor);
        for (Aggregation aggregation : this.aggr) {
            PropertyVisitor.visitChildScope((Scope)parent, (PropertyVisitor)visitor, (PropertySink)aggregation);
        }
        return visitor.newScope();
    }

    private class MyInsertMerger
    extends InsertMerger.Base<MyTree> {
        private final InsertMerger[] mergers;

        public MyInsertMerger() {
            this.mergers = new InsertMerger[AMapAggregation.this.size];
            for (int i = 0; i < AMapAggregation.this.size; ++i) {
                this.mergers[i] = AMapAggregation.this.aggr[i].newInsertMerger();
            }
        }

        public void pushQ(MyTree tree) {
            for (int i = 0; i < AMapAggregation.this.size; ++i) {
                this.mergers[i].push(tree.trees[i]);
            }
        }

        public void clear() {
            for (int i = 0; i < AMapAggregation.this.size; ++i) {
                this.mergers[i].clear();
            }
        }

        public MyTree get() {
            Tree[] trees = new Tree[AMapAggregation.this.size];
            for (int i = 0; i < AMapAggregation.this.size; ++i) {
                trees[i] = this.mergers[i].get();
            }
            return new MyTree(trees);
        }
    }

    private class MyFullMerger
    extends FullMerger.Base<MyTree> {
        private final FullMerger[] mergers;

        public MyFullMerger() {
            this.mergers = new FullMerger[AMapAggregation.this.size];
            for (int i = 0; i < AMapAggregation.this.size; ++i) {
                this.mergers[i] = AMapAggregation.this.aggr[i].newMerger();
            }
        }

        public void pushQ(MyTree tree) {
            for (int i = 0; i < AMapAggregation.this.size; ++i) {
                this.mergers[i].push(tree.trees[i]);
            }
        }

        public void pop() {
            for (int i = 0; i < AMapAggregation.this.size; ++i) {
                this.mergers[i].pop();
            }
        }

        public void clear() {
            for (int i = 0; i < AMapAggregation.this.size; ++i) {
                this.mergers[i].clear();
            }
        }

        public MyTree get() {
            Tree[] trees = new Tree[AMapAggregation.this.size];
            for (int i = 0; i < AMapAggregation.this.size; ++i) {
                trees[i] = this.mergers[i].get();
            }
            return new MyTree(trees);
        }
    }

    private class MyState
    implements State {
        private final State[] inner;

        public MyState(int flips) {
            this.inner = new State[AMapAggregation.this.size];
            for (int i = 0; i < AMapAggregation.this.size; ++i) {
                this.inner[i] = AMapAggregation.this.aggr[i].newState(flips);
            }
        }

        public void yield(Scope parent, Object obj) {
            Row row = (Row)AMapAggregation.this.expr.eval(parent, obj);
            if (row == null) {
                return;
            }
            Scope newScope = new Scope(parent, obj);
            for (int i = 0; i < Math.min(AMapAggregation.this.size, row.size()); ++i) {
                this.inner[i].yield(newScope, row.get(i));
            }
        }

        public Tree flip() {
            Tree[] trees = new Tree[AMapAggregation.this.size];
            int innerLength = this.inner.length;
            for (int i = 0; i < innerLength; ++i) {
                trees[i] = this.inner[i].flip();
            }
            return new MyTree(trees);
        }
    }

    private static class MyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final Tree[] trees;

        public MyTree(Tree[] trees) {
            this.trees = trees;
        }
    }
}

