/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertySink;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;

@Export(value={"areduce"})
@Help(key="aggregation-areduce")
public class AReduceAggregation
implements Aggregation {
    private static final long serialVersionUID = 1L;
    private final Scalar<Iterable> expr;
    private final Aggregation aggr;

    public AReduceAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Scalar)queue.scalar((Type)Type.SEQ).get();
        this.aggr = (Aggregation)queue.withContext(queue.context().newChildSource(queue.metadata().withType(this.extractType()))).aggregation((Type)Type.OBJECT).get();
    }

    private Type extractType() {
        return ((SeqType)Type.extract((Type)this.expr.type(), SeqType.class)).type();
    }

    public State newState(int flips) {
        return new MyState(this.aggr.newState(flips));
    }

    public Type type() {
        return this.aggr.type();
    }

    public String toString() {
        return "areduce(" + this.expr + ", " + this.aggr + ")";
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public long ttl() {
        return this.aggr.ttl();
    }

    public long weight() {
        return 8L + this.aggr.weight();
    }

    public FullMerger newMerger() {
        return this.aggr.newMerger();
    }

    public InsertMerger newInsertMerger() {
        return this.aggr.newInsertMerger();
    }

    public Object eval(Scope parent, Tree tree, WindowBounds bounds) {
        return this.aggr.eval(parent, tree, bounds);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.expr.visit(parent, visitor);
        return PropertyVisitor.visitChildScope((Scope)parent, (PropertyVisitor)visitor, (PropertySink)this.aggr);
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr, this.aggr});
    }

    private class MyState
    implements State {
        private final State inner;

        public MyState(State inner) {
            this.inner = inner;
        }

        public void yield(Scope parent, Object obj) {
            Iterable it = (Iterable)AReduceAggregation.this.expr.eval(parent, obj);
            if (it == null) {
                return;
            }
            Scope newScope = new Scope(parent, obj);
            for (Object o : it) {
                this.inner.yield(newScope, o);
            }
        }

        public Tree flip() {
            return this.inner.flip();
        }
    }
}

