/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SimpleMerger;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

@Export(value={"all"})
@Help(key="aggregation-all")
public class AllAggregation
implements Aggregation<Boolean> {
    private static final long serialVersionUID = 1L;
    private final Scalar<Boolean> expr;

    public AllAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Scalar)queue.scalar((Type)Type.BOOLEAN).get();
    }

    public String toString() {
        return "all(" + this.expr + ")";
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return SimpleMerger.makeFullMerger((SimpleMerger)new MyMerger());
    }

    public InsertMerger newInsertMerger() {
        return SimpleMerger.makeInsertMerger((SimpleMerger)new MyMerger());
    }

    public Type<Boolean> type() {
        return Type.BOOLEAN;
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 8L;
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr});
    }

    public Boolean eval(Scope parent, Tree tree, WindowBounds bounds) {
        return ((MyTree)tree).value;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.expr.visit(parent, visitor);
        return visitor.newScope();
    }

    private static class MyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final boolean value;

        public MyTree(boolean value) {
            this.value = value;
        }
    }

    private class MyState
    implements State {
        private volatile boolean value = true;

        private MyState() {
        }

        public void yield(Scope parent, Object obj) {
            Boolean newValue = (Boolean)AllAggregation.this.expr.eval(parent, obj);
            if (!Boolean.TRUE.equals(newValue)) {
                this.value = false;
            }
        }

        public Tree flip() {
            MyTree tree = new MyTree(this.value);
            this.value = true;
            return tree;
        }
    }

    private class MyMerger
    extends SimpleMerger.Base<MyTree> {
        private volatile int wrongs = 0;

        private MyMerger() {
        }

        public void addQ(MyTree tree) {
            if (!tree.value) {
                ++this.wrongs;
            }
        }

        public void removeQ(MyTree tree) {
            if (!tree.value) {
                --this.wrongs;
            }
        }

        public void clear() {
            this.wrongs = 0;
        }

        public MyTree get() {
            return new MyTree(this.wrongs == 0);
        }
    }
}

