/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SimpleMerger;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.modules.FallbackToLiteral;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

@Export(value={"avg"})
@Help(key="aggregation-avg")
public class AvgAggregation
implements Aggregation<Double> {
    private static final long serialVersionUID = 1L;
    private final Scalar<Double> expr;
    private final Scalar<Double> weight;

    public AvgAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Scalar)queue.scalar((Type)Type.NUMBER).get();
        this.weight = (Scalar)queue.scalar((Type)Type.NUMBER).getOptional(new FallbackToLiteral(Type.NUMBER, 1.0));
    }

    private static double safe(double mean) {
        return Double.isNaN(mean) || Double.isInfinite(mean) ? 0.0 : mean;
    }

    public Type<Double> type() {
        return Type.NUMBER;
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public String toString() {
        if (Level.CONSTANT.accepts(this.weight) && Double.valueOf(1.0).equals(this.weight.eval(null, null))) {
            return "avg(" + this.expr + ")";
        }
        return "avg(" + this.expr + ", " + this.weight + ")";
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr, this.weight});
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return SimpleMerger.makeFullMerger((SimpleMerger)new MyMerger());
    }

    public InsertMerger newInsertMerger() {
        return SimpleMerger.makeInsertMerger((SimpleMerger)new MyMerger());
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 16L;
    }

    public Double eval(Scope parent, Tree tree, WindowBounds bounds) {
        return ((MyTree)tree).mean;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.weight.visit(parent, visitor);
        this.expr.visit(parent, visitor);
        return visitor.newScope();
    }

    private class MyMerger
    extends SimpleMerger.Base<MyTree> {
        private volatile double sumw = 0.0;
        private volatile double mean = 0.0;

        private MyMerger() {
        }

        public void addQ(MyTree tree) {
            this.sumw += tree.sumw;
            this.mean += (tree.mean - this.mean) * tree.sumw / this.sumw;
            this.mean = AvgAggregation.safe(this.mean);
        }

        public void removeQ(MyTree tree) {
            this.addQ(new MyTree(-tree.sumw, tree.mean));
        }

        public void clear() {
            this.sumw = 0.0;
            this.mean = 0.0;
        }

        public MyTree get() {
            return new MyTree(this.sumw, this.mean);
        }
    }

    private class MyState
    implements State {
        private volatile double sumw = 0.0;
        private volatile double mean = 0.0;

        private MyState() {
        }

        public void yield(Scope parent, Object obj) {
            Double w = (Double)AvgAggregation.this.weight.eval(parent, obj);
            if (w == null) {
                return;
            }
            double temp = this.sumw + w;
            Double x = (Double)AvgAggregation.this.expr.eval(parent, obj);
            if (x == null) {
                return;
            }
            double delta = x - this.mean;
            double r = delta * (w / temp);
            this.mean += r;
            this.sumw = temp;
            this.mean = AvgAggregation.safe(this.mean);
        }

        public Tree flip() {
            MyTree tree = new MyTree(this.sumw, this.mean);
            this.sumw = 0.0;
            this.mean = 0.0;
            return tree;
        }
    }

    private static class MyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final double sumw;
        private final double mean;

        private MyTree(double sumw, double mean) {
            this.sumw = sumw;
            this.mean = mean;
        }
    }
}

