/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SimpleMerger;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.ConstantHelper;

@Export(value={"count"})
@Help(key="aggregation-count")
public class CountAggregation
implements Aggregation<Double> {
    private static final long serialVersionUID = 1L;
    private final Scalar expr;

    public CountAggregation(ArgQueue queue) throws PipeException {
        this.expr = (Scalar)queue.scalar((Type)Type.OBJECT).getOptional(q -> (Scalar)q.compiler().expression().compileToQueue(new String[]{"true"}).scalar((Type)Type.OBJECT).get());
    }

    public Type<Double> type() {
        return Type.NUMBER;
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public String toString() {
        if (ConstantHelper.isConstant((Object)this.expr) && Boolean.TRUE.equals(ConstantHelper.evaluate((Expression)this.expr))) {
            return "count(*)";
        }
        return "count(" + this.expr + ")";
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return SimpleMerger.makeFullMerger((SimpleMerger)new MyMerger());
    }

    public InsertMerger newInsertMerger() {
        return SimpleMerger.makeInsertMerger((SimpleMerger)new MyMerger());
    }

    public long ttl() {
        return this.expr.ttl();
    }

    public long weight() {
        return 8L;
    }

    public Double eval(Scope parent, Tree tree, WindowBounds bounds) {
        return ((MyTree)tree).value;
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.expr});
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.expr.visit(parent, visitor);
        return visitor.newScope();
    }

    private class MyMerger
    extends SimpleMerger.Base<MyTree> {
        private volatile long value = 0L;

        private MyMerger() {
        }

        public void addQ(MyTree tree) {
            this.value += tree.value;
        }

        public void removeQ(MyTree tree) {
            this.value -= tree.value;
        }

        public void clear() {
            this.value = 0L;
        }

        public MyTree get() {
            return new MyTree(this.value);
        }
    }

    private class MyState
    implements State {
        private volatile long value = 0L;

        private MyState() {
        }

        public void yield(Scope parent, Object obj) {
            Object o = CountAggregation.this.expr.eval(parent, obj);
            if (o != null && !Boolean.FALSE.equals(o)) {
                ++this.value;
            }
        }

        public Tree flip() {
            MyTree result = new MyTree(this.value);
            this.value = 0L;
            return result;
        }
    }

    private static class MyTree
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final long value;

        private MyTree(long value) {
            this.value = value;
        }
    }
}

