/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.aggregations;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.SafeGson;

@Export(value={"describe"})
@Help(key="aggregation-describe")
public class DescribeAggregation
implements Aggregation<String> {
    private final Aggregation<Object> aggregation;

    public DescribeAggregation(ArgQueue queue) throws PipeException {
        this.aggregation = (Aggregation)queue.aggregation((Type)Type.OBJECT).get();
    }

    public State newState(int flips) {
        return this.aggregation.newState(flips);
    }

    public FullMerger newMerger() {
        return this.aggregation.newMerger();
    }

    public InsertMerger newInsertMerger() {
        return this.aggregation.newInsertMerger();
    }

    public String eval(Scope parent, Tree tree, WindowBounds bounds) {
        return SafeGson.toJson(tree);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.aggregation.visit(parent, visitor);
        return visitor.newScope();
    }

    public Level level() {
        return Level.AGGREGATION;
    }

    public long ttl() {
        return this.aggregation.ttl();
    }

    public long weight() {
        return this.aggregation.weight();
    }

    public Type<String> type() {
        return Type.STRING;
    }

    public String toString() {
        return "describe(" + this.aggregation + ")";
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.aggregation});
    }
}

